/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event.pull;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.event.pull.PullRequestEvent;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

@AsynchronousPreferred
public class PullRequestParticipantsUpdatedEvent
extends PullRequestEvent {
    private final Set<StashUser> addedParticipants;
    private final Set<StashUser> removedParticipants;

    public PullRequestParticipantsUpdatedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull Set<StashUser> added, @Nonnull Set<StashUser> removed) {
        super(source, pullRequest, PullRequestAction.UPDATED);
        this.addedParticipants = ImmutableSet.copyOf(added);
        this.removedParticipants = ImmutableSet.copyOf(removed);
    }

    @Nonnull
    public Set<StashUser> getAddedParticipants() {
        return this.addedParticipants;
    }

    @Nonnull
    public Set<StashUser> getRemovedParticipants() {
        return this.removedParticipants;
    }
}

