/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.validation;

import javax.validation.ConstraintValidatorContext;

public class IntegerValidator {
    protected boolean allowNegative;

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Integer n = this.convert(value);
        return n != null && (this.allowNegative || n >= 0);
    }

    private Integer convert(Object value) {
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return ((Number)value).intValue();
            }
            if (value instanceof Long && (Long)value <= Integer.MAX_VALUE) {
                return ((Long)value).intValue();
            }
        }
        return null;
    }
}

