/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

public enum DiffSegmentType {
    ADDED(0, false, true),
    CONTEXT(1, true, true),
    REMOVED(2, true, false);

    private final int id;
    private final boolean inDestination;
    private final boolean inSource;

    private DiffSegmentType(int id, boolean inSource, boolean inDestination) {
        this.id = id;
        this.inDestination = inDestination;
        this.inSource = inSource;
    }

    public static DiffSegmentType fromId(int id) {
        for (DiffSegmentType value : DiffSegmentType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No DiffSegmentType is associated with ID [" + id + "]");
    }

    public int getId() {
        return this.id;
    }

    public boolean isInDestination() {
        return this.inDestination;
    }

    public boolean isInSource() {
        return this.inSource;
    }
}

