/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PageImpl<T>
implements Page<T> {
    private final PageRequest pageRequest;
    private final Iterable<T> values;
    private final boolean lastPage;
    private volatile Integer size;

    public PageImpl(PageRequest pageRequest, int size, Iterable<T> values, boolean lastPage) {
        this(pageRequest, values, lastPage);
        this.size = size;
    }

    public PageImpl(PageRequest pageRequest, Iterable<T> values, boolean lastPage) {
        this.pageRequest = pageRequest;
        this.values = values;
        this.lastPage = lastPage;
    }

    @Override
    public int getStart() {
        return this.pageRequest.getStart();
    }

    @Override
    public int getLimit() {
        return this.pageRequest.getLimit();
    }

    @Override
    @Nullable
    public String getFilter() {
        return this.pageRequest.getFilter();
    }

    @Override
    public int getSize() {
        if (this.size == null) {
            this.inspectValues();
        }
        return this.size;
    }

    @Override
    public boolean getIsLastPage() {
        return this.lastPage;
    }

    private synchronized void inspectValues() {
        this.size = Iterables.size(this.values);
    }

    @Override
    @Nonnull
    public Iterable<T> getValues() {
        return this.values;
    }

    @Override
    public PageRequest getNextPageRequest() {
        return this.getIsLastPage() ? null : new PageRequestImpl(this.getNextPageOffset(), this.getLimit());
    }

    @Override
    public SortedMap<Integer, T> getOrdinalIndexedValues() {
        TreeMap<Integer, T> valueMap = new TreeMap<Integer, T>();
        int index = this.getStart();
        for (T value : this.values) {
            valueMap.put(index++, value);
        }
        return valueMap;
    }

    protected int getNextPageOffset() {
        return this.getStart() + this.getLimit();
    }

    @Override
    @Nonnull
    public <E> PageImpl<E> transform(@Nonnull Function<? super T, ? extends E> transformFunction) {
        ImmutableList list = ImmutableList.copyOf((Iterable)Iterables.transform(this.values, transformFunction));
        return this.size == null ? new PageImpl<T>(this.pageRequest, list, this.lastPage) : new PageImpl<T>(this.pageRequest, this.size, list, this.lastPage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageImpl page = (PageImpl)o;
        if (this.lastPage != page.lastPage) {
            return false;
        }
        if (this.pageRequest != null ? !this.pageRequest.equals(page.pageRequest) : page.pageRequest != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(page.size) : page.size != null) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(page.values) : page.values != null);
    }

    public int hashCode() {
        int result = this.pageRequest != null ? this.pageRequest.hashCode() : 0;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        result = 31 * result + (this.lastPage ? 1 : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        return result;
    }
}

