/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.DiffWhitespace;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DiffRequest {
    private final Set<String> paths;
    private final Repository repository;
    private final String sinceId;
    private final String untilId;
    private final DiffWhitespace whitespace;

    private DiffRequest(Repository repository, String sinceId, String untilId, Set<String> paths, DiffWhitespace whitespace) {
        this.repository = repository;
        this.sinceId = sinceId;
        this.untilId = untilId;
        this.paths = paths;
        this.whitespace = whitespace;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private final Repository repository;
        private String sinceId;
        private final String untilId;
        private DiffWhitespace whitespace;

        public Builder(Repository repository, String untilId) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            if (StringUtils.isBlank((String)untilId)) {
                throw new IllegalStateException("An \"until\" ID is required to build a diff");
            }
            this.untilId = untilId;
            this.whitespace = DiffWhitespace.SHOW;
        }

        public DiffRequest build() {
            return new DiffRequest(this.repository, this.sinceId, this.untilId, (Set)this.paths.build(), this.whitespace);
        }

        public Builder path(String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        public Builder paths(Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        public Builder paths(String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        public Builder sinceId(String value) {
            this.sinceId = value;
            return this;
        }

        public Builder whitespace(DiffWhitespace value) {
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value"));
            return this;
        }
    }
}

