/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.AbstractRepositoryRequest;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class RepositoryUpdateRequest
extends AbstractRepositoryRequest {
    private final int id;

    private RepositoryUpdateRequest(String name, boolean forkable, int id, boolean publiclyAccessible) {
        super(name, forkable, publiclyAccessible);
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static class Builder
    extends AbstractRepositoryRequest.AbstractBuilder<Builder> {
        private int id;

        public Builder() {
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
            Integer repositoryId = repository.getId();
            if (repositoryId != null) {
                this.id = repositoryId;
            }
        }

        public Builder(@Nonnull RepositoryUpdateRequest request) {
            super(request);
            this.id = request.getId();
        }

        @Nonnull
        public RepositoryUpdateRequest build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (Object)"The name with which to update the repository is required");
            return new RepositoryUpdateRequest(this.name, this.forkable, this.id, this.publiclyAccessible);
        }

        @Nonnull
        public Builder id(int value) {
            this.id = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

