/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import java.util.HashMap;
import java.util.Map;

public class CgiRequest {
    static final String KEY_AUTH_TYPE = "AUTH_TYPE";
    static final String KEY_CONTENT_TYPE = "CONTENT_TYPE";
    static final String KEY_CONTENT_LENGTH = "CONTENT_LENGTH";
    static final String KEY_GATEWAY_INTERFACE = "GATEWAY_INTERFACE";
    static final String KEY_PATH_INFO = "PATH_INFO";
    static final String KEY_SCRIPT_NAME = "SCRIPT_NAME";
    static final String KEY_QUERY_STRING = "QUERY_STRING";
    static final String KEY_REMOTE_ADDRESS = "REMOTE_ADDRESS";
    static final String KEY_REMOTE_HOST = "REMOTE_HOST";
    static final String KEY_REMOTE_USER = "REMOTE_USER";
    static final String KEY_HTTPS = "HTTPS";
    static final String KEY_REQUEST_METHOD = "REQUEST_METHOD";
    static final String KEY_SERVER_NAME = "SERVER_NAME";
    static final String KEY_SERVER_PORT = "SERVER_PORT";
    static final String KEY_SERVER_PROTOCOL = "SERVER_PROTOCOL";
    static final String KEY_SERVER_SOFTWARE = "SERVER_SOFTWARE";
    private String authType;
    private int contentLength;
    private String contentType;
    private String pathInfo;
    private String queryString;
    private String remoteAddress;
    private String remoteHost;
    private String remoteUser;
    private boolean secure;
    private String requestMethod;
    private String serverName;
    private Integer serverPort;
    private String serverProtocol;
    private String serverSoftware;
    private Map<String, String> httpHeaders;

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public String getServerSoftware() {
        return this.serverSoftware;
    }

    public void setServerSoftware(String serverSoftware) {
        this.serverSoftware = serverSoftware;
    }

    public synchronized void setHttpHeader(String key, String value) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new HashMap<String, String>();
        }
        this.httpHeaders.put(key, value);
    }

    private static String nullSafe(String s) {
        return s == null ? "" : s;
    }

    public Map<String, String> buildEnvironmentVariables() {
        HashMap<String, String> env = new HashMap<String, String>();
        int len = this.contentLength;
        if (len < 0) {
            len = 0;
        }
        env.put(KEY_AUTH_TYPE, CgiRequest.nullSafe(this.authType));
        env.put(KEY_CONTENT_LENGTH, CgiRequest.nullSafe(Integer.toString(len)));
        env.put(KEY_CONTENT_TYPE, CgiRequest.nullSafe(this.contentType));
        env.put(KEY_GATEWAY_INTERFACE, "CGI/1.1");
        if (this.pathInfo != null && this.pathInfo.length() > 0) {
            env.put(KEY_PATH_INFO, CgiRequest.nullSafe(this.pathInfo));
            env.put(KEY_SCRIPT_NAME, CgiRequest.nullSafe(this.pathInfo));
        }
        env.put(KEY_QUERY_STRING, CgiRequest.nullSafe(this.queryString));
        env.put(KEY_REMOTE_ADDRESS, CgiRequest.nullSafe(this.remoteAddress));
        env.put(KEY_REMOTE_HOST, CgiRequest.nullSafe(this.remoteHost));
        env.put(KEY_REMOTE_USER, CgiRequest.nullSafe(this.remoteUser));
        env.put(KEY_REQUEST_METHOD, CgiRequest.nullSafe(this.requestMethod));
        env.put(KEY_SERVER_NAME, CgiRequest.nullSafe(this.serverName));
        env.put(KEY_SERVER_PORT, CgiRequest.nullSafe(Integer.toString(this.serverPort)));
        env.put(KEY_SERVER_PROTOCOL, CgiRequest.nullSafe(this.serverProtocol));
        env.put(KEY_SERVER_SOFTWARE, CgiRequest.nullSafe(this.serverSoftware));
        if (this.httpHeaders != null) {
            for (Map.Entry<String, String> httpHeader : this.httpHeaders.entrySet()) {
                env.put("HTTP_" + httpHeader.getKey().toUpperCase().replace('-', '_'), CgiRequest.nullSafe(httpHeader.getValue()));
            }
        }
        env.put(KEY_HTTPS, this.secure ? "ON" : "OFF");
        return env;
    }
}

