/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import org.apache.commons.lang.StringUtils;

public enum ScmType {
    GIT(0, "Git", "git"){

        @Override
        public String getDisplayId(String changesetId) {
            return StringUtils.substring((String)changesetId, (int)0, (int)7);
        }
    };

    private final int id;
    private final String fullName;
    private final String shortName;

    private ScmType(int id, String fullName, String shortName) {
        this.id = id;
        this.fullName = fullName;
        this.shortName = shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getId() {
        return this.id;
    }

    public static ScmType fromId(int id) {
        for (ScmType type : ScmType.values()) {
            if (type.id != id) continue;
            return type;
        }
        throw new IllegalArgumentException("No ScmType is available for ID [" + id + "]");
    }

    public String getShortName() {
        return this.shortName;
    }

    public abstract String getDisplayId(String var1);
}

