/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.crowd;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.user.Person;
import javax.annotation.Nullable;

public class CrowdUser
implements Person {
    private final String name;
    private final String displayName;
    private final String emailAddress;
    private final String directoryName;
    private final Boolean readOnly;

    public CrowdUser(User user) {
        this(user, null, null);
    }

    public CrowdUser(User user, @Nullable String directoryName, @Nullable Boolean readOnly) {
        this(user.getName(), user.getDisplayName(), user.getEmailAddress(), directoryName, readOnly);
    }

    public CrowdUser(String name, String displayName, String emailAddress, String directoryName, Boolean readOnly) {
        this.name = name;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.directoryName = directoryName;
        this.readOnly = readOnly;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isReadOnly() {
        return Boolean.TRUE.equals(this.readOnly);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrowdUser)) {
            return false;
        }
        CrowdUser crowdUser = (CrowdUser)o;
        if (this.directoryName != null ? !this.directoryName.equals(crowdUser.directoryName) : crowdUser.directoryName != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(crowdUser.readOnly) : crowdUser.readOnly != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(crowdUser.displayName) : crowdUser.displayName != null) {
            return false;
        }
        if (this.emailAddress != null ? !this.emailAddress.equals(crowdUser.emailAddress) : crowdUser.emailAddress != null) {
            return false;
        }
        return this.name.equals(crowdUser.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.emailAddress != null ? this.emailAddress.hashCode() : 0);
        result = 31 * result + (this.directoryName != null ? this.directoryName.hashCode() : 0);
        result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CrowdUser{name='" + this.name + '\'' + ", displayName='" + this.displayName + '\'' + ", emailAddress='" + this.emailAddress + '\'' + ", directoryName='" + this.directoryName + '\'' + ", readOnly='" + this.readOnly + '\'' + '}';
    }
}

