/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.crowd;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.stash.crowd.AllowedDirectoryOperations;
import com.atlassian.stash.crowd.CrowdGroup;
import com.atlassian.stash.crowd.CrowdUser;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.InvalidTokenException;
import com.atlassian.stash.exception.LicenseLimitException;
import com.atlassian.stash.exception.NoMailHostConfigurationException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.OperationNotPermittedException;
import com.atlassian.stash.exception.SendingEmailException;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface CrowdAdminService {
    public boolean canCreateGroups();

    public boolean canCreateUsers();

    public boolean canDeleteGroups();

    public void createUser(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4) throws IntegrityException, LicenseLimitException, CrowdRuntimeException;

    public void createUser(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, boolean var5) throws IntegrityException, LicenseLimitException, CrowdRuntimeException;

    public void createUserWithGeneratedPassword(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3) throws IntegrityException, LicenseLimitException, NoMailHostConfigurationException, CrowdRuntimeException, SendingEmailException;

    @Nullable
    public CrowdUser findUser(@Nonnull String var1);

    @Nullable
    public CrowdUser findUserWithDirectoryInfo(@Nonnull String var1);

    @Nonnull
    public Page<CrowdUser> findUsers(@Nonnull PageRequest var1);

    @Nonnull
    public AllowedDirectoryOperations getAllowedOperationsForDirectoryContaining(@Nonnull String var1);

    public boolean userExists(@Nonnull String var1);

    public CrowdUser deleteUser(@Nonnull String var1) throws IntegrityException, ForbiddenException, NoSuchEntityException, CrowdRuntimeException;

    public CrowdUser updateUserDetails(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3);

    public void updateUserPassword(@Nonnull String var1, @Nonnull String var2);

    public Page<CrowdGroup> findGroups(@Nonnull PageRequest var1);

    public boolean groupExists(@Nonnull String var1);

    public CrowdGroup createGroup(@Nonnull String var1) throws IntegrityException, CrowdRuntimeException;

    public CrowdGroup deleteGroup(@Nonnull String var1) throws IntegrityException, ForbiddenException, NoSuchEntityException, OperationNotPermittedException, CrowdRuntimeException;

    public Page<CrowdUser> findUsersInGroup(@Nonnull PageRequest var1, @Nonnull String var2);

    public Page<CrowdUser> findUsersNotInGroup(@Nonnull PageRequest var1, @Nonnull String var2);

    public Page<String> findGroupsForUser(@Nonnull PageRequest var1, @Nonnull String var2);

    public Page<String> findGroupsWithoutUser(@Nonnull PageRequest var1, @Nonnull String var2);

    public void addUserToGroup(@Nonnull String var1, @Nonnull String var2) throws ForbiddenException, NoSuchEntityException, LicenseLimitException, CrowdRuntimeException, OperationNotPermittedException;

    public void removeUserFromGroup(@Nonnull String var1, @Nonnull String var2) throws IntegrityException, ForbiddenException, NoSuchEntityException, CrowdRuntimeException, OperationNotPermittedException;

    public void preparePasswordReset(@Nonnull String var1) throws NoSuchEntityException, NoMailHostConfigurationException, SendingEmailException, CrowdRuntimeException;

    @Nullable
    public User findByPasswordResetRequest(@Nonnull String var1);

    public void resetPassword(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3) throws InvalidTokenException, NoSuchEntityException, CrowdRuntimeException;
}

