/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.spring.container;

import com.atlassian.event.Event;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerContextLoadedEvent;
import javax.servlet.ServletContext;
import org.apache.log4j.Category;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringContainerContext
implements ContainerContext {
    private Category log = Category.getInstance((Class)SpringContainerContext.class);
    private ServletContext servletContext;
    private ApplicationContext applicationContext;
    private BucketListableBeanFactory beanFactory = new BucketListableBeanFactory(null);

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
        this.setApplicationContext((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)context));
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getComponent(Object key) throws ComponentNotFoundException {
        if (this.applicationContext == null) {
            this.log.fatal((Object)"Spring Application context has not been set");
            throw new IllegalStateException("Spring Application context has not been set");
        }
        if (key == null) {
            this.log.error((Object)"The component key cannot be null");
            throw new ComponentNotFoundException("The component key cannot be null");
        }
        if (key instanceof Class) {
            String[] names = this.beanFactory.getBeanNamesForType((Class)key);
            if (names == null || names.length == 0 || names.length > 1) {
                throw new ComponentNotFoundException("The container is unable to resolve single instance of " + ((Class)key).getName() + " number of instances found was: " + names.length);
            }
            key = names[0];
        }
        try {
            return this.beanFactory.getBean(key.toString());
        }
        catch (BeansException e) {
            throw new ComponentNotFoundException("Failed to find component: " + e.getMessage(), e);
        }
    }

    public Object createComponent(Class clazz) {
        return this.beanFactory.autowire(clazz, 1, false);
    }

    public void autowireComponent(Object bean) {
        if (this.beanFactory != null) {
            this.beanFactory.autowireNonSingletonBeanProperties(bean, 1, false);
        } else {
            this.log.debug((Object)("ApplicationContext is null or has not been set. Cannot proceed with autowiring of component: " + bean));
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws ApplicationContextException {
        this.applicationContext = appContext;
        this.beanFactory = new BucketListableBeanFactory(appContext);
    }

    public synchronized void refresh() {
        ContextLoader loader = new ContextLoader();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        if (ctx != null) {
            loader.closeWebApplicationContext(this.servletContext);
        }
        loader.initWebApplicationContext(this.servletContext);
        if (this.applicationContext == null) {
            this.setApplicationContext((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext));
        }
        this.contextReloaded();
    }

    public boolean isSetup() {
        return this.applicationContext != null;
    }

    protected void contextReloaded() {
        if (this.applicationContext != null) {
            this.applicationContext.publishEvent((ApplicationEvent)new ContainerContextLoadedEvent(this.applicationContext));
        }
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void publishEvent(Event e) {
        this.applicationContext.publishEvent((ApplicationEvent)e);
    }

    private static class BucketListableBeanFactory
    extends DefaultListableBeanFactory {
        public BucketListableBeanFactory(ApplicationContext context) {
            super((BeanFactory)context);
        }

        public void autowireNonSingletonBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
            if (autowireMode != 1 && autowireMode != 2) {
                throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
            }
            RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
            bd.setSingleton(false);
            this.populateBean(existingBean.getClass().getName(), bd, (BeanWrapper)new BeanWrapperImpl(existingBean));
        }

        public String toString() {
            return "toString overridden for performance reasons";
        }
    }
}

