/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.internal.elements.search;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.PageObjects;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.search.AnyQuery;
import com.atlassian.pageobjects.elements.search.SearchQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractSearchQuery<E, Q extends SearchQuery<E, Q>>
implements SearchQuery<E, Q> {
    @Inject
    protected Timeouts timeouts;
    @Inject
    protected PageBinder pageBinder;
    protected final Supplier<Iterable<E>> querySupplier;

    protected AbstractSearchQuery(@Nonnull Supplier<Iterable<E>> querySupplier) {
        this.querySupplier = Objects.requireNonNull(querySupplier, "querySupplier");
    }

    @Override
    @Nonnull
    public final Q filter(final @Nonnull Predicate<? super E> predicate) {
        return this.newInstance(new Supplier<Iterable<E>>(){

            public Iterable<E> get() {
                return Iterables.filter((Iterable)((Iterable)AbstractSearchQuery.this.querySupplier.get()), (Predicate)predicate);
            }
        });
    }

    @Override
    @Nonnull
    public final <F> AnyQuery<F> map(@Nonnull Function<? super E, F> mapper) {
        return this.newAnyQueryInstance(this.mapSupplier(mapper));
    }

    @Override
    @Nonnull
    public final <F> AnyQuery<F> flatMap(@Nonnull Function<? super E, Iterable<F>> mapper) {
        return this.newAnyQueryInstance(this.flatMapSupplier(mapper));
    }

    @Override
    @Nonnull
    public final <F> AnyQuery<F> bindTo(@Nonnull Class<F> pageObjectClass, Object ... extraArgs) {
        return this.map(PageObjects.bindTo((PageBinder)this.pageBinder, pageObjectClass, (Object[])extraArgs));
    }

    public final Iterable<E> get() {
        return this.getResultNow();
    }

    @Override
    @Nullable
    public final E first() {
        return (E)Iterables.getFirst(this.getResultNow(), null);
    }

    @Override
    @Nonnull
    public final Iterable<E> now() {
        return this.getResultNow();
    }

    @Override
    @Nonnull
    public final TimedCondition hasResult() {
        return Conditions.forSupplier(this.timeouts, new Supplier<Boolean>(){

            public Boolean get() {
                return AbstractSearchQuery.this.hasResultNow();
            }
        });
    }

    @Override
    @Nonnull
    public final TimedQuery<Iterable<E>> timed() {
        return Queries.forSupplier(this.timeouts, new Supplier<Iterable<E>>(){

            public Iterable<E> get() {
                return AbstractSearchQuery.this.getResultNow();
            }
        });
    }

    @Nonnull
    protected abstract Q newInstance(@Nonnull Supplier<Iterable<E>> var1);

    @Nonnull
    protected abstract <F> AnyQuery<F> newAnyQueryInstance(@Nonnull Supplier<Iterable<F>> var1);

    protected final <F> Supplier<Iterable<F>> flatMapSupplier(final @Nonnull Function<? super E, Iterable<F>> mapper) {
        return new Supplier<Iterable<F>>(){

            public Iterable<F> get() {
                return FluentIterable.from((Iterable)((Iterable)AbstractSearchQuery.this.querySupplier.get())).transformAndConcat(mapper);
            }
        };
    }

    protected final <F> Supplier<Iterable<F>> mapSupplier(final @Nonnull Function<? super E, F> mapper) {
        return new Supplier<Iterable<F>>(){

            public Iterable<F> get() {
                return Iterables.transform((Iterable)((Iterable)AbstractSearchQuery.this.querySupplier.get()), (Function)mapper);
            }
        };
    }

    private Iterable<E> getResultNow() {
        return (Iterable)this.querySupplier.get();
    }

    private boolean hasResultNow() {
        return !Iterables.isEmpty(this.getResultNow());
    }
}

