/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.timeout;

import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.hamcrest.StringDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBasedTimeouts
implements Timeouts {
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedTimeouts.class);
    public static final String PROPERTY_PREFIX = StringConcat.asString("com.atlassian.timeout.");
    public static final String DEFAULT_PROPERTY_KEY = PropertiesBasedTimeouts.propKey(TimeoutType.DEFAULT);
    private final Map<String, String> properties;
    private final long defaultValue;

    public static PropertiesBasedTimeouts fromFile(String path) {
        return new PropertiesBasedTimeouts(PropertiesBasedTimeouts.loadFromFile(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertiesBasedTimeouts fromClassPath(String path, ClassLoader loader) {
        InputStream is = loader.getResourceAsStream(path);
        try {
            PropertiesBasedTimeouts propertiesBasedTimeouts = new PropertiesBasedTimeouts(Objects.requireNonNull(is, "input stream can't be null"));
            return propertiesBasedTimeouts;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static PropertiesBasedTimeouts fromClassPath(String path) {
        return PropertiesBasedTimeouts.fromClassPath(path, PropertiesBasedTimeouts.class.getClassLoader());
    }

    private static String propKey(TimeoutType timeoutType) {
        return PROPERTY_PREFIX + timeoutType.toString();
    }

    public PropertiesBasedTimeouts(Properties properties) {
        this.properties = Maps.fromProperties((Properties)Objects.requireNonNull(properties, "properties can't be null"));
        this.defaultValue = this.validateAndGetDefault();
    }

    public PropertiesBasedTimeouts(InputStream reader) {
        this(PropertiesBasedTimeouts.loadFromReader(reader));
    }

    private static Properties loadFromReader(InputStream reader) {
        try {
            Properties answer = new Properties();
            answer.load(reader);
            return answer;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read from path <" + reader + ">", e);
        }
    }

    private static Properties loadFromFile(String path) {
        Properties properties;
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(path);
            Properties answer = new Properties();
            answer.load(reader);
            properties = answer;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Unable to read from path <" + path + ">", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)reader);
        return properties;
    }

    private long validateAndGetDefault() {
        Preconditions.checkArgument((boolean)this.properties.containsKey(DEFAULT_PROPERTY_KEY), (Object)("Must contain default timeout property with key <" + DEFAULT_PROPERTY_KEY + ">"));
        return Long.parseLong(this.properties.get(DEFAULT_PROPERTY_KEY));
    }

    @Override
    public long timeoutFor(TimeoutType timeoutType) {
        String timeout = this.properties.get(PropertiesBasedTimeouts.propKey(timeoutType));
        if (timeout == null) {
            return this.defaultValue(timeoutType);
        }
        try {
            return Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            log.warn(new StringDescription().appendText("Corrupted property value for key ").appendValue((Object)PropertiesBasedTimeouts.propKey(timeoutType)).appendText(": ").appendValue((Object)timeout).appendText(". Returning default timeout value: ").appendValue((Object)this.defaultValue).toString());
            return this.defaultValue;
        }
    }

    private long defaultValue(TimeoutType timeoutType) {
        if (TimeoutType.EVALUATION_INTERVAL == timeoutType) {
            return 100L;
        }
        return this.defaultValue;
    }
}

