/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.util.Backoff;
import com.atlassian.pageobjects.elements.query.util.LinearBackoff;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class Poll<T>
implements Callable<T> {
    Callable<T> query;
    Matcher<? super T> condition;
    Backoff interval;
    long timeout;
    Clock clock;
    ExpirationHandler expirationHandler;

    @VisibleForTesting
    public Poll(Callable<T> query, Clock clock) {
        this(query);
        this.clock = clock;
    }

    private Poll(Callable<T> query) {
        this.query = query;
        this.condition = Matchers.notNullValue();
        this.interval = new LinearBackoff(50L);
        this.timeout = 10000L;
        this.clock = Clock.systemUTC();
        this.expirationHandler = ExpirationHandler.RETURN_CURRENT;
    }

    public static <T> Poll<T> poll(Callable<T> query) {
        return new Poll<T>(query);
    }

    public Poll<T> every(long interval, TimeUnit unit) {
        this.interval = new LinearBackoff(TimeUnit.MILLISECONDS.convert(interval, unit));
        return this;
    }

    public Poll<T> until(Matcher<? super T> condition) {
        this.condition = condition;
        return this;
    }

    public Poll<T> withTimeout(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value.");
        }
        this.timeout = TimeUnit.MILLISECONDS.convert(time, unit);
        return this;
    }

    public Poll<T> onFailure(ExpirationHandler expirationHandler) {
        this.expirationHandler = expirationHandler;
        return this;
    }

    @Override
    public T call() throws RuntimeException {
        try {
            T current;
            long start = this.clock.millis();
            long deadline = start + this.timeout;
            while (this.clock.millis() < deadline) {
                current = this.query.call();
                if (this.condition.matches(current)) {
                    return current;
                }
                long bounded = Math.max(1L, deadline - this.clock.millis());
                this.interval.yield(bounded);
            }
            this.interval.resetBackoff();
            current = this.query.call();
            if (this.condition.matches(current)) {
                return current;
            }
            return this.expirationHandler.expired(this.query.toString(), current, this.timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

