/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.annotations.Internal;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.atlassian.webdriver.utils.Check;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Internal
public class WebDriverLocators {
    private WebDriverLocators() {
        throw new AssertionError((Object)("Do not instantiate " + this.getClass().getSimpleName()));
    }

    @Nonnull
    public static WebDriverLocatable root() {
        return new WebDriverRootLocator();
    }

    @Nonnull
    public static WebDriverLocatable single(By locator) {
        return new WebDriverSingleLocator(locator, WebDriverLocators.root());
    }

    @Nonnull
    public static WebDriverLocatable nested(By locator, WebDriverLocatable parent) {
        return new WebDriverSingleLocator(locator, parent);
    }

    @Nonnull
    public static WebDriverLocatable list(WebElement element, By locator, int locatorIndex, WebDriverLocatable parent) {
        return new WebDriverListLocator(element, locator, locatorIndex, parent);
    }

    @Nonnull
    public static WebDriverLocatable staticElement(WebElement element) {
        return new WebDriverStaticLocator(element);
    }

    public static boolean isStale(WebElement webElement) {
        try {
            webElement.getTagName();
            return false;
        }
        catch (NoSuchElementException | StaleElementReferenceException ignored) {
            return true;
        }
    }

    private static Poller.WaitTimeout withinTimeout(WebDriverLocatable.LocateTimeout timeout) {
        return timeout.timeout() > 0L ? Poller.by(timeout.timeout()) : Poller.now();
    }

    private static long getTimeout(WebDriverLocatable.LocateTimeout timeout) {
        return timeout.timeout() > 0L ? timeout.timeout() : 5000L;
    }

    private static class WebDriverListLocator
    implements WebDriverLocatable {
        private WebElement webElement = null;
        private final By locator;
        private final int locatorIndex;
        private final WebDriverLocatable parent;

        public WebDriverListLocator(WebElement element, By locator, int locatorIndex, WebDriverLocatable parent) {
            Preconditions.checkArgument((locatorIndex >= 0 ? 1 : 0) != 0, (Object)("locator index is negative:" + locatorIndex));
            this.webElement = Objects.requireNonNull(element, "element can't be null");
            this.locatorIndex = locatorIndex;
            this.locator = Objects.requireNonNull(locator, "locator");
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public By getLocator() {
            return null;
        }

        @Override
        public WebDriverLocatable getParent() {
            return this.parent;
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            if (WebDriverLocators.isStale(this.webElement)) {
                try {
                    this.webElement = Poller.waitUntil(this.queryForElementInList(driver, timeout), Matchers.notNullValue(WebElement.class), WebDriverLocators.withinTimeout(timeout));
                }
                catch (AssertionError notLocated) {
                    throw new NoSuchElementException(new StringDescription().appendText("Unable to locate element in collection.").appendText("\nLocator: ").appendValue((Object)this.locator).appendText("\nLocator Index: ").appendValue((Object)this.locatorIndex).toString());
                }
            }
            return this.webElement;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            SearchContext searchContext = this.parent.waitUntilLocated(driver, timeout);
            List webElements = searchContext.findElements(this.locator);
            return this.locatorIndex <= webElements.size() - 1;
        }

        public String toString() {
            return StringConcat.asString("WebDriverListLocator[locator=", this.locator, ",index=", this.locatorIndex, "]");
        }

        private TimedQuery<WebElement> queryForElementInList(final WebDriver driver, WebDriverLocatable.LocateTimeout timeout) {
            return new AbstractTimedQuery<WebElement>(WebDriverLocators.getTimeout(timeout), timeout.pollInterval(), ExpirationHandler.RETURN_NULL){

                @Override
                protected boolean shouldReturn(WebElement currentEval) {
                    return true;
                }

                @Override
                protected WebElement currentValue() {
                    if (parent.isPresent(driver, WebDriverLocatable.LocateTimeout.zero())) {
                        List webElements = parent.waitUntilLocated(driver, WebDriverLocatable.LocateTimeout.zero()).findElements(locator);
                        return locatorIndex < webElements.size() ? (WebElement)webElements.get(locatorIndex) : null;
                    }
                    return null;
                }
            };
        }
    }

    private static class WebDriverSingleLocator
    implements WebDriverLocatable {
        private WebElement webElement = null;
        private boolean webElementLocated = false;
        private final By locator;
        private final WebDriverLocatable parent;

        public WebDriverSingleLocator(By locator, WebDriverLocatable parent) {
            this.locator = Objects.requireNonNull(locator, "locator");
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        @Nonnull
        public By getLocator() {
            return this.locator;
        }

        @Override
        @Nonnull
        public WebDriverLocatable getParent() {
            return this.parent;
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            if (!this.webElementLocated || WebDriverLocators.isStale(this.webElement)) {
                try {
                    this.webElement = Poller.waitUntil(this.queryForSingleElement(driver, timeout), Matchers.notNullValue(WebElement.class), WebDriverLocators.withinTimeout(timeout));
                }
                catch (AssertionError notFound) {
                    throw new NoSuchElementException(new StringDescription().appendText("Unable to locate element by timeout.").appendText("\nLocator: ").appendValue((Object)this.locator).appendText("\nTimeout: ").appendValue((Object)timeout.timeout()).appendText("ms.").toString());
                }
                this.webElementLocated = true;
            }
            return this.webElement;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            try {
                return Check.elementExists((By)this.locator, (SearchContext)this.parent.waitUntilLocated(driver, timeout));
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        @Nonnull
        public String toString() {
            return StringConcat.asString("WebDriverSingleLocator[locator=", this.locator, "]");
        }

        private TimedQuery<WebElement> queryForSingleElement(final WebDriver driver, WebDriverLocatable.LocateTimeout timeout) {
            return new AbstractTimedQuery<WebElement>(WebDriverLocators.getTimeout(timeout), timeout.pollInterval(), ExpirationHandler.RETURN_NULL){

                @Override
                protected boolean shouldReturn(WebElement currentEval) {
                    return true;
                }

                @Override
                protected WebElement currentValue() {
                    if (parent.isPresent(driver, WebDriverLocatable.LocateTimeout.zero())) {
                        try {
                            return parent.waitUntilLocated(driver, WebDriverLocatable.LocateTimeout.zero()).findElement(locator);
                        }
                        catch (NoSuchElementException e) {
                            return null;
                        }
                    }
                    return null;
                }
            };
        }
    }

    private static class WebDriverRootLocator
    implements WebDriverLocatable {
        private WebDriverRootLocator() {
        }

        @Override
        public By getLocator() {
            return null;
        }

        @Override
        public WebDriverLocatable getParent() {
            return null;
        }

        @Override
        @Nonnull
        public final SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            return driver;
        }

        @Override
        public final boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            return true;
        }
    }

    private static class WebDriverStaticLocator
    implements WebDriverLocatable {
        private final WebElement element;

        WebDriverStaticLocator(WebElement element) {
            this.element = element;
        }

        @Override
        public By getLocator() {
            if (WebDriverLocators.isStale(this.element)) {
                return null;
            }
            String id = this.element.getAttribute("id");
            if (id != null) {
                return By.id((String)id);
            }
            return null;
        }

        @Override
        @Nonnull
        public WebDriverLocatable getParent() {
            return WebDriverLocators.root();
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) throws NoSuchElementException {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            if (WebDriverLocators.isStale(this.element)) {
                throw new NoSuchElementException("WebElement got stale");
            }
            return this.element;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Objects.requireNonNull(driver, "driver");
            Objects.requireNonNull(timeout, "timeout");
            return !WebDriverLocators.isStale(this.element);
        }
    }
}

