/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.cookie;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class ServerCookie
implements Serializable {
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(ServerCookie.OLD_COOKIE_PATTERN, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };
    private static final String ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));
    public static final boolean STRICT_SERVLET_COMPLIANCE = Boolean.valueOf(System.getProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false"));
    public static final boolean ALWAYS_ADD_EXPIRES = Boolean.valueOf(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALWAYS_ADD_EXPIRES", "true"));
    private static final String tspecials = ",; ";
    private static final String tspecials2 = "()<>@,;:\\\"/[]?={} \t";
    private static final String tspecials2NoSlash = "()<>@,;:\\\"[]?={} \t";

    private ServerCookie() {
    }

    public static boolean isToken(String value, String literals) {
        String tspecials;
        String string = tspecials = literals == null ? tspecials : literals;
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCTL(String value, int version) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public static boolean isToken2(String value, String literals) {
        String tspecials2;
        String string = tspecials2 = literals == null ? tspecials2 : literals;
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials2.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static void appendCookieValue(StringBuffer headerBuf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure, boolean isHttpOnly) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("=");
        version = ServerCookie.maybeQuote2(version, buf, value, true);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                ServerCookie.maybeQuote2(version, buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            ServerCookie.maybeQuote2(version, buf, domain);
        }
        if (maxAge >= 0) {
            if (version > 0) {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
            if (version == 0 || ALWAYS_ADD_EXPIRES) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            }
        }
        if (path != null) {
            buf.append("; Path=");
            if (version == 0) {
                ServerCookie.maybeQuote2(version, buf, path);
            } else {
                ServerCookie.maybeQuote2(version, buf, path, tspecials2NoSlash, false);
            }
        }
        if (isSecure) {
            buf.append("; Secure");
        }
        if (isHttpOnly) {
            buf.append("; HttpOnly");
        }
        headerBuf.append(buf);
    }

    public static boolean alreadyQuoted(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    public static int maybeQuote2(int version, StringBuffer buf, String value) {
        return ServerCookie.maybeQuote2(version, buf, value, false);
    }

    public static int maybeQuote2(int version, StringBuffer buf, String value, boolean allowVersionSwitch) {
        return ServerCookie.maybeQuote2(version, buf, value, null, allowVersionSwitch);
    }

    public static int maybeQuote2(int version, StringBuffer buf, String value, String literals, boolean allowVersionSwitch) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else {
            if (ServerCookie.containsCTL(value, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (ServerCookie.alreadyQuoted(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 1, value.length() - 1));
                buf.append('\"');
            } else if (allowVersionSwitch && !STRICT_SERVLET_COMPLIANCE && version == 0 && !ServerCookie.isToken2(value, literals)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
                version = 1;
            } else if (version == 0 && !ServerCookie.isToken(value, literals)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else if (version == 1 && !ServerCookie.isToken2(value, literals)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else {
                buf.append(value);
            }
        }
        return version;
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

