package com.atlassian.sal.api.usersettings;

import com.atlassian.fugue.Option;

import java.util.Set;

/**
 * A builder for {@link UserSettings}
 */
public interface UserSettingsBuilder
{
    /**
     * add an extra entry to the builder, overwriting any existing value stored against key (regardless of type)
     * @param key the key to store the value against, if null no operation takes place
     * @param value the non-null String to store
     * @throws IllegalArgumentException if value is null
     * @return this builder
     */
    UserSettingsBuilder put(String key, String value);

    /**
     * add an extra entry to the builder, overwriting any existing value stored against key (regardless of type)
     * @param key the key to store the value against, if null no operation takes place
     * @param value the boolean to store
     * @return this builder
     */
    UserSettingsBuilder put(String key, boolean value);

    /**
     * add an extra entry to the builder, overwriting any existing value stored against key (regardless of type)
     * @param key the key to store the value against, if null no operation takes place
     * @param value the long to store
     * @return this builder
     */
    UserSettingsBuilder put(String key, long value);

    /**
     * remove an entry from the builder
     * @param key the key for the entry to remove
     * @return this builder
     */
    UserSettingsBuilder remove(String key);

    /**
     * @param key the setting key being queried
     * @return a {@link Option.Some Some} containing the value stored against key if one exists, a {@link Option.None}
     * otherwise. Values can be of type String, Boolean or Long.
     */
    Option<Object> get(String key);

    /**
     * @return the set of keys known to this UserSettings
     */
    Set<String> getKeys();

    /**
     *
     * @return an immutable UserSettings matching the contents of this builder
     */
    UserSettings build();
}
