/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class XsrfTokenAccessorTest
extends SpringAwareTestCase {
    private XsrfTokenAccessor xsrfTokenAccessor;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;

    public void setXsrfTokenAccessor(XsrfTokenAccessor xsrfTokenAccessor) {
        this.xsrfTokenAccessor = xsrfTokenAccessor;
    }

    @Before
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
    }

    @Test
    public void testXsrfTokenAccessorAvailable() {
        Assert.assertNotNull((String)"XSRF Token Accessor should be available to plugins", (Object)this.xsrfTokenAccessor);
    }

    @Test
    public void testGetXsrfTokenCreate() {
        String token = this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)this.request, (HttpServletResponse)this.response, true);
        Assert.assertNotNull((String)"XSRF token accessor should not return a null token when create is true", (Object)token);
    }

    @Test
    public void testGetXsrfTokenExisting() {
        String token = this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)this.request, (HttpServletResponse)this.response, true);
        Assert.assertNotNull((String)"XSRF token accessor should not return a null token when create is true", (Object)token);
        this.request.setCookies(this.response.getCookies());
        Assert.assertEquals((String)"XSRF token accessor should return the same token on successive invocations on the same request", (Object)token, (Object)this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)this.request, (HttpServletResponse)this.response, false));
        Assert.assertEquals((String)"XSRF token accessor should return the same token on successive invocations on the same request", (Object)token, (Object)this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)this.request, (HttpServletResponse)this.response, true));
    }

    @Test
    public void testGetXsrfTokenNotExisting() {
        Assert.assertNull((String)"XSRF token accessor should return null when a clean request with no session or cookies is passed and create is set to false", (Object)this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)this.request, (HttpServletResponse)this.response, false));
    }
}

