/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThreadLocalContextManagerTest
extends SpringAwareTestCase {
    private ThreadLocalContextManager<Object> threadLocalContextManager;
    private Object oldContext;

    public void setThreadLocalContextManager(ThreadLocalContextManager<Object> threadLocalContextManager) {
        this.threadLocalContextManager = threadLocalContextManager;
    }

    @Before
    public void saveContext() {
        this.oldContext = this.threadLocalContextManager.getThreadLocalContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAndSetThreadLocalContext() throws ExecutionException, InterruptedException {
        final Object context = this.threadLocalContextManager.getThreadLocalContext();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Object> result = executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ThreadLocalContextManagerTest.this.threadLocalContextManager.setThreadLocalContext(context);
                    return ThreadLocalContextManagerTest.this.threadLocalContextManager.getThreadLocalContext();
                }
            });
            Assert.assertEquals((Object)context, (Object)result.get());
        }
        finally {
            executorService.shutdown();
        }
    }

    @After
    public void cleanUp() {
        if (this.oldContext != null) {
            this.threadLocalContextManager.setThreadLocalContext(this.oldContext);
        } else {
            this.threadLocalContextManager.clearThreadLocalContext();
        }
        this.oldContext = null;
    }
}

