/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.AppSpecificInfoProvider;
import com.atlassian.sal.api.search.SearchMatch;
import com.atlassian.sal.api.search.SearchProvider;
import com.atlassian.sal.api.search.SearchResults;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class SearchProviderTest
extends SpringAwareTestCase {
    private SearchProvider searchProvider;
    private AppSpecificInfoProvider infoProvider;

    public void setSearchProvider(SearchProvider searchProvider) {
        this.searchProvider = searchProvider;
    }

    public void setInfoProvider(AppSpecificInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    @Test
    public void testSearchProviderAvailable() {
        Assert.assertNotNull((String)"SearchProvider must be available to plugins", (Object)this.searchProvider);
    }

    @Test
    public void testSearchButNoMatch() {
        SearchResults sresults = this.searchProvider.search(this.infoProvider.getAdminUsername(), "superweirdsearchtermwahaha");
        Assert.assertNotNull((String)"Should never return null", (Object)sresults);
    }

    @Test
    public void testSearchWithProfileButNoMatch() {
        SearchResults sresults = this.searchProvider.search(this.infoProvider.getAdminUserKey(), "superweirdsearchtermwahaha");
        Assert.assertNotNull((String)"Should never return null", (Object)sresults);
    }

    @Test
    public void testSearchWithMatch() {
        String matchingSearchTerm = this.infoProvider.getMatchingSearchTerm();
        boolean searchSupported = StringUtils.isNotBlank((String)matchingSearchTerm);
        SearchResults sresults = this.searchProvider.search(this.infoProvider.getAdminUsername(), searchSupported ? matchingSearchTerm : "dummySearchTerm");
        Assert.assertNotNull((String)"Should never return null", (Object)sresults);
        if (searchSupported) {
            this.checkSearchResults(sresults);
        }
    }

    @Test
    public void testSearchWithProfileWithMatch() {
        String matchingSearchTerm = this.infoProvider.getMatchingSearchTerm();
        boolean searchSupported = StringUtils.isNotBlank((String)matchingSearchTerm);
        SearchResults sresults = this.searchProvider.search(this.infoProvider.getAdminUserKey(), searchSupported ? matchingSearchTerm : "dummySearchTerm");
        Assert.assertNotNull((String)"Should never return null", (Object)sresults);
        if (searchSupported) {
            this.checkSearchResults(sresults);
        }
    }

    private void checkSearchResults(SearchResults sresults) {
        Assert.assertTrue((String)"We expect matches in search", (sresults.getMatches().size() > 0 ? 1 : 0) != 0);
        for (String content : this.infoProvider.getExpectedMatchingContents()) {
            boolean found = false;
            for (SearchMatch match : sresults.getMatches()) {
                if (!this.contains(match.getTitle(), content) && !this.contains(match.getUrl(), content) && !this.contains(match.getExcerpt(), content)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("the expected content should exist in the search results:" + content), (boolean)found);
        }
    }

    private boolean contains(String result, String expectedContent) {
        if (result != null) {
            return result.contains(expectedContent);
        }
        return false;
    }
}

