/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.prettyurls;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.junit.Test;

public class PrettyUrlsTest
extends SpringAwareTestCase {
    private RequestFactory requestFactory;
    private ApplicationProperties applicationProperties;

    @Test
    public void assert200() throws ResponseException {
        URI uri = UriBuilder.fromUri((String)this.applicationProperties.getBaseUrl()).path("prettyurls").path("helloworld").build(new Object[0]);
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, uri.toString());
        request.execute(new ResponseHandler(){

            public void handle(Response response) throws ResponseException {
                Assert.assertEquals((long)200L, (long)response.getStatusCode());
            }
        });
    }

    @Test
    public void assert404() throws ResponseException {
        URI uri = UriBuilder.fromUri((String)this.applicationProperties.getBaseUrl()).path("prettyurls").path("path-that-does-not-exist").build(new Object[0]);
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, uri.toString());
        request.execute(new ResponseHandler(){

            public void handle(Response response) throws ResponseException {
                Assert.assertEquals((long)404L, (long)response.getStatusCode());
            }
        });
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void setRequestFactory(RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }
}

