/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.MetricTag;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class MetricTagContext {
    private static InheritableThreadLocal<Set<MetricTag>> threadLocal = new InheritableThreadLocal<Set<MetricTag>>(){

        @Override
        protected Set<MetricTag> childValue(Set<MetricTag> parentValue) {
            return parentValue == null ? null : new HashSet<MetricTag>(parentValue);
        }
    };

    public static Closeable put(MetricTag tag) {
        Set<MetricTag> set = MetricTagContext.getOrCreateLocalSet();
        set.add(tag);
        return () -> set.remove(tag);
    }

    @Nullable
    public static Set<MetricTag> getAll() {
        Set set = (Set)threadLocal.get();
        return set == null ? Collections.emptySet() : new HashSet(set);
    }

    private static Set<MetricTag> getOrCreateLocalSet() {
        HashSet set = (HashSet)threadLocal.get();
        if (set == null) {
            set = new HashSet();
            threadLocal.set(set);
        }
        return set;
    }

    public static interface Closeable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

