/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.strategy.ProfilingStrategy;
import com.atlassian.util.profiling.strategy.impl.StackProfilingStrategy;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UtilTimerStack {
    private static StackProfilingStrategy defaultProfilingStrategy = new StackProfilingStrategy();
    private static final ConcurrentLinkedQueue<ProfilingStrategy> strategies = new ConcurrentLinkedQueue();

    public static void push(String name) {
        if (defaultProfilingStrategy.isEnabled()) {
            defaultProfilingStrategy.start(name);
        }
        for (ProfilingStrategy strategy : strategies) {
            if (!strategy.isEnabled()) continue;
            strategy.start(name);
        }
    }

    public static void pop(String name) {
        defaultProfilingStrategy.stop(name);
        for (ProfilingStrategy strategy : strategies) {
            strategy.stop(name);
        }
    }

    public static void add(ProfilingStrategy strategy) {
        if (!defaultProfilingStrategy.equals(strategy) && !strategies.contains(strategy)) {
            strategies.add(strategy);
        }
    }

    public static void remove(ProfilingStrategy strategy) {
        strategies.remove(strategy);
    }

    public static StackProfilingStrategy getDefaultStrategy() {
        return defaultProfilingStrategy;
    }

    public static boolean isActive() {
        if (defaultProfilingStrategy.isEnabled()) {
            return true;
        }
        for (ProfilingStrategy strategy : strategies) {
            if (!strategy.isEnabled()) continue;
            return true;
        }
        return false;
    }
}

