/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.filters;

import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.util.profiling.filters.FilterConfigAware;
import com.atlassian.util.profiling.filters.ProfilingStatusUpdateViaRequestStrategy;
import com.atlassian.util.profiling.filters.StatusUpdateStrategy;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger((Class)ProfilingFilter.class);
    protected static final String AUTOSTART_PARAM = "autostart";
    protected final StatusUpdateStrategy statusUpdateStrategy;

    public ProfilingFilter() {
        this.statusUpdateStrategy = new ProfilingStatusUpdateViaRequestStrategy();
    }

    protected ProfilingFilter(StatusUpdateStrategy statusUpdateStrategy) {
        if (statusUpdateStrategy == null) {
            throw new IllegalArgumentException("statusUpdateStrategy must not be null!");
        }
        this.statusUpdateStrategy = statusUpdateStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.statusUpdateStrategy.setStateViaRequest(request);
        if (!this.isFilterOn()) {
            chain.doFilter(request, response);
            return;
        }
        String resource = this.getResourceName(request);
        UtilTimerStack.push(resource);
        try {
            chain.doFilter(request, response);
        }
        finally {
            UtilTimerStack.pop(resource);
        }
    }

    private boolean isFilterOn() {
        return UtilTimerStack.isActive();
    }

    private String getResourceName(ServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            return (String)request.getAttribute("javax.servlet.include.request_uri");
        }
        return ((HttpServletRequest)request).getRequestURI();
    }

    public void init(FilterConfig filterConfig) {
        if (filterConfig != null) {
            String autostartParam = filterConfig.getInitParameter(AUTOSTART_PARAM);
            if (autostartParam != null) {
                if ("true".equals(autostartParam)) {
                    log.debug("[Filter: {}] defaulting to on [{}=true]", (Object)filterConfig.getFilterName(), (Object)AUTOSTART_PARAM);
                    this.turnProfilingOn();
                } else if ("false".equals(autostartParam)) {
                    log.debug("[Filter: {}] defaulting to off [{}=false]", (Object)filterConfig.getFilterName(), (Object)AUTOSTART_PARAM);
                    this.turnProfilingOff();
                } else {
                    log.debug("[Filter: {}] autostart value: {} is unknown no action taken]", (Object)filterConfig.getFilterName(), (Object)autostartParam);
                }
            }
            if (this.statusUpdateStrategy instanceof FilterConfigAware) {
                ((FilterConfigAware)((Object)this.statusUpdateStrategy)).configure(filterConfig);
            }
        }
    }

    public void destroy() {
    }

    protected void turnProfilingOn() {
        UtilTimerStack.setActive(true);
    }

    protected void turnProfilingOff() {
        UtilTimerStack.setMinTotalTime(0L);
        UtilTimerStack.setActive(false);
    }
}

