/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.ProfilingTimerBean;
import com.atlassian.util.profiling.UtilTimerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilTimerStack {
    private static final Logger log = LoggerFactory.getLogger((Class)UtilTimerStack.class);
    private static ThreadLocal current = new ThreadLocal();
    public static final String ACTIVATE_PROPERTY = "atlassian.profile.activate";
    public static final String ACTIVATE_MEMORY_PROPERTY = "atlassian.profile.activate.memory";
    public static final String MIN_TIME = "atlassian.profile.mintime";
    public static final String MIN_TOTAL_TIME = "atlassian.profile.mintotaltime";
    private static volatile long configuredMinTime;
    private static volatile long configuredMinTotalTime;
    private static volatile boolean activeFlag;
    private static volatile boolean profileMemoryFlag;
    private static UtilTimerLogger logger;

    public static void push(String name) {
        ProfilingTimerBean currentTimer;
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        if (UtilTimerStack.isProfileMemory()) {
            newTimer.setStartMem();
        }
        if ((currentTimer = (ProfilingTimerBean)current.get()) != null) {
            currentTimer.addChild(newTimer);
        }
        current.set(newTimer);
    }

    public static void pop(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean currentTimer = (ProfilingTimerBean)current.get();
        if (UtilTimerStack.isProfileMemory()) {
            currentTimer.setEndMem();
        }
        if (currentTimer != null && name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                if (currentTimer.getTotalTime() > UtilTimerStack.getMinTotalTime()) {
                    UtilTimerStack.printTimes(currentTimer);
                }
                current.set(null);
            } else {
                current.set(parent);
            }
        } else if (currentTimer != null) {
            UtilTimerStack.printTimes(currentTimer);
            current.set(null);
            log.debug("Unmatched Timer.  Was expecting {}, instead got {}", (Object)currentTimer.getResource(), (Object)name);
        }
    }

    private static void printTimes(ProfilingTimerBean currentTimer) {
        String printable = currentTimer.getPrintable(UtilTimerStack.getMinTime());
        if (printable != null && !"".equals(printable.trim())) {
            logger.log(printable);
        }
    }

    private static long getMinTime() {
        return configuredMinTime;
    }

    private static long getMinTotalTime() {
        return configuredMinTotalTime;
    }

    public static boolean isActive() {
        return activeFlag;
    }

    public static void setMinTime(long minTime) {
        configuredMinTime = minTime;
    }

    public static void setMinTotalTime(long minTotalTime) {
        configuredMinTotalTime = minTotalTime;
    }

    public static boolean isProfileMemory() {
        return profileMemoryFlag;
    }

    public static void setActive(boolean active) {
        activeFlag = active;
    }

    public static void setProfileMemory(boolean active) {
        profileMemoryFlag = active;
    }

    public static void setLogger(UtilTimerLogger logger) {
        UtilTimerStack.logger = logger;
    }

    static {
        activeFlag = false;
        profileMemoryFlag = false;
        configuredMinTime = Long.getLong(MIN_TIME, 0L);
        configuredMinTotalTime = Long.getLong(MIN_TOTAL_TIME, 0L);
        activeFlag = "true".equalsIgnoreCase(System.getProperty(ACTIVATE_PROPERTY, "false"));
        profileMemoryFlag = "true".equalsIgnoreCase(System.getProperty(ACTIVATE_MEMORY_PROPERTY, "false"));
        logger = new UtilTimerLogger(){

            public void log(String s) {
                log.debug(s);
            }
        };
    }
}

