/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.filters;

import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger((Class)ProfilingFilter.class);
    private static final String ON_OFF_INIT_PARAM = "activate.param";
    private static final String START_STOP_PARAM = "autostart";
    private static final String DEFAULT_ON_OFF_PARAM = "profile.filter";
    private static String onOffParameter = "profile.filter";
    private static String onOffParameterEquals = onOffParameter + "=";
    private FilterConfig filterConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int idx;
        String queryString;
        String paramValue = null;
        if (request instanceof HttpServletRequest && (queryString = ((HttpServletRequest)request).getQueryString()) != null && (idx = queryString.indexOf(onOffParameterEquals)) >= 0) {
            paramValue = queryString.substring(idx + onOffParameterEquals.length());
            idx = queryString.indexOf(38);
            if (idx >= 0) {
                paramValue = paramValue.substring(0, idx);
            }
        }
        if (paramValue != null) {
            this.setFilterState(paramValue);
        }
        if (!this.isFilterOn()) {
            chain.doFilter(request, response);
            return;
        }
        String resource = this.getResourceName(request);
        UtilTimerStack.push(resource);
        try {
            chain.doFilter(request, response);
        }
        finally {
            UtilTimerStack.pop(resource);
        }
    }

    private void setFilterState(String paramValue) {
        if ("on".equals(paramValue) || "true".equals(paramValue)) {
            this.turnFilterOn();
        } else if ("off".equals(paramValue) || "false".equals(paramValue)) {
            this.turnFilterOff();
        } else if (paramValue.length() > 0 && Character.isDigit(paramValue.charAt(0))) {
            try {
                this.turnFilterOnAndSetFilterThreshold(Long.parseLong(paramValue));
                this.turnFilterOn();
            }
            catch (NumberFormatException e) {
                log.debug("Could not parse {} to Long value", (Object)paramValue);
            }
        }
    }

    private String getResourceName(ServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            return (String)request.getAttribute("javax.servlet.include.request_uri");
        }
        return ((HttpServletRequest)request).getRequestURI();
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if (filterConfig.getInitParameter(ON_OFF_INIT_PARAM) != null) {
            log.debug("[Filter: {}] Using parameter [{}]", (Object)filterConfig.getFilterName(), (Object)filterConfig.getInitParameter(ON_OFF_INIT_PARAM));
            onOffParameter = filterConfig.getInitParameter(ON_OFF_INIT_PARAM);
            onOffParameterEquals = onOffParameter + "=";
        }
        if ("true".equals(filterConfig.getInitParameter(START_STOP_PARAM))) {
            log.debug("[Filter: {}] defaulting to on [{}=true]", (Object)filterConfig.getFilterName(), (Object)START_STOP_PARAM);
            this.turnFilterOn();
        } else if ("false".equals(filterConfig.getInitParameter(START_STOP_PARAM))) {
            log.debug("[Filter: {}] defaulting to off [{}=false]", (Object)filterConfig.getFilterName(), (Object)START_STOP_PARAM);
            this.turnFilterOff();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            this.setFilterConfig(filterConfig);
        }
    }

    public void destroy() {
    }

    private boolean isFilterOn() {
        return UtilTimerStack.isActive();
    }

    private void turnFilterOn() {
        log.debug("[Filter: {}] Turning filter on [{}=on]", (Object)this.filterConfig.getFilterName(), (Object)onOffParameter);
        UtilTimerStack.setActive(true);
    }

    private void turnFilterOnAndSetFilterThreshold(long minTotalTime) {
        log.debug("[Filter: {}] Turning filter on [{}=on] with threshold {}ms", new Object[]{this.filterConfig.getFilterName(), onOffParameter, new Long(minTotalTime)});
        UtilTimerStack.setMinTotalTime(minTotalTime);
        UtilTimerStack.setActive(true);
    }

    private void turnFilterOff() {
        log.debug("[Filter: {}] Turning filter off [{}=off]", (Object)this.filterConfig.getFilterName(), (Object)onOffParameter);
        UtilTimerStack.setMinTotalTime(0L);
        UtilTimerStack.setActive(false);
    }
}

