/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.test;

import com.atlassian.plugin.test.Matchers;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.rules.ExternalResource;

public class CapturedLogging
extends ExternalResource {
    private final Class logSource;
    private Appender appender;
    private List<LoggingEvent> loggingEvents;
    private Logger logger;
    private Level savedLoggerLevel;
    private boolean savedLoggerAdditivity;

    public CapturedLogging(Class logSource) {
        this.logSource = logSource;
    }

    public List<LoggingEvent> getLoggingEvents() {
        return this.loggingEvents;
    }

    protected void before() throws Throwable {
        super.before();
        this.loggingEvents = new ArrayList<LoggingEvent>();
        this.appender = new AppenderSkeleton(){

            protected void append(LoggingEvent event) {
                CapturedLogging.this.loggingEvents.add(event);
            }

            public void close() {
            }

            public boolean requiresLayout() {
                return false;
            }
        };
        this.logger = LogManager.getLogger((Class)this.logSource);
        this.savedLoggerLevel = this.logger.getLevel();
        this.savedLoggerAdditivity = this.logger.getAdditivity();
        this.logger.setLevel(Level.ALL);
        this.logger.setAdditivity(false);
        this.logger.addAppender(this.appender);
    }

    protected void after() {
        this.logger.setLevel(this.savedLoggerLevel);
        this.logger.setAdditivity(this.savedLoggerAdditivity);
        this.logger.removeAppender(this.appender);
        super.after();
    }

    public static Matcher<CapturedLogging> didLog(final Matcher<LoggingEvent> loggingEventMatcher) {
        return new TypeSafeMatcher<CapturedLogging>(){

            protected boolean matchesSafely(CapturedLogging capturedLogging) {
                return org.hamcrest.Matchers.hasItem((Matcher)loggingEventMatcher).matches(capturedLogging.getLoggingEvents());
            }

            public void describeTo(Description description) {
                description.appendText("some LoggingEvent that ");
                description.appendDescriptionOf((SelfDescribing)loggingEventMatcher);
            }
        };
    }

    public static Matcher<CapturedLogging> didLogError(Matcher<String> messageMatcher) {
        return CapturedLogging.didLog(CapturedLogging.levelAndMessageMatch(Level.ERROR, messageMatcher));
    }

    public static Matcher<CapturedLogging> didLogError(String ... substrings) {
        return CapturedLogging.didLogError(Matchers.containsAllStrings(substrings));
    }

    public static Matcher<CapturedLogging> didLogWarn(Matcher<String> messageMatcher) {
        return CapturedLogging.didLog(CapturedLogging.levelAndMessageMatch(Level.WARN, messageMatcher));
    }

    public static Matcher<CapturedLogging> didLogWarn(String ... substrings) {
        return CapturedLogging.didLogWarn(Matchers.containsAllStrings(substrings));
    }

    public static Matcher<CapturedLogging> didLogInfo(Matcher<String> messageMatcher) {
        return CapturedLogging.didLog(CapturedLogging.levelAndMessageMatch(Level.INFO, messageMatcher));
    }

    public static Matcher<CapturedLogging> didLogInfo(String ... substrings) {
        return CapturedLogging.didLogInfo(Matchers.containsAllStrings(substrings));
    }

    public static Matcher<CapturedLogging> didLogDebug(Matcher<String> messageMatcher) {
        return CapturedLogging.didLog(CapturedLogging.levelAndMessageMatch(Level.DEBUG, messageMatcher));
    }

    public static Matcher<CapturedLogging> didLogDebug(String ... substrings) {
        return CapturedLogging.didLogDebug(Matchers.containsAllStrings(substrings));
    }

    public static Matcher<LoggingEvent> levelIs(final Level level) {
        return new TypeSafeMatcher<LoggingEvent>(){

            protected boolean matchesSafely(LoggingEvent loggingEvent) {
                return level.equals((Object)loggingEvent.getLevel());
            }

            public void describeTo(Description description) {
                description.appendText("has level ");
                description.appendValue((Object)level);
            }
        };
    }

    public static Matcher<LoggingEvent> messageMatches(final Matcher<String> stringMatcher) {
        return new TypeSafeMatcher<LoggingEvent>(){

            protected boolean matchesSafely(LoggingEvent loggingEvent) {
                return stringMatcher.matches(loggingEvent.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("has message ");
                description.appendDescriptionOf((SelfDescribing)stringMatcher);
            }
        };
    }

    public static Matcher<LoggingEvent> throwableMatches(final Matcher<Throwable> throwableMatcher) {
        return new TypeSafeMatcher<LoggingEvent>(){

            protected boolean matchesSafely(LoggingEvent loggingEvent) {
                return Optional.ofNullable(loggingEvent.getThrowableInformation()).map(ti -> throwableMatcher.matches((Object)ti.getThrowable())).orElse(false);
            }

            public void describeTo(Description description) {
                description.appendText("has throwable which ");
                description.appendDescriptionOf((SelfDescribing)throwableMatcher);
            }
        };
    }

    public String toString() {
        List loggingEventsAsString = Lists.transform(this.loggingEvents, (Function)new Function<LoggingEvent, String>(){

            public String apply(LoggingEvent loggingEvent) {
                return loggingEvent.getLevel() + ":" + loggingEvent.getMessage();
            }
        });
        return "CapturedLogging( " + loggingEventsAsString + ")";
    }

    public static Matcher<LoggingEvent> levelAndMessageMatch(Level level, Matcher<String> messageMatcher) {
        return CoreMatchers.allOf(CapturedLogging.levelIs(level), CapturedLogging.messageMatches(messageMatcher));
    }
}

