/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.spi.permission.scope;

import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.util.ServletUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public final class DownloadScopeHelper {
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private final String[] pathPrefixes;

    public DownloadScopeHelper(String ... pathPrefixes) {
        this.pathPrefixes = pathPrefixes;
        this.apiResourceInfo = Iterables.transform(Arrays.asList(pathPrefixes), (Function)new Function<String, ApiResourceInfo>(){

            public ApiResourceInfo apply(String from) {
                return new ApiResourceInfo(from, "GET");
            }
        });
    }

    public boolean allow(HttpServletRequest request, String user) {
        String pathInfo = ServletUtils.extractPathInfo(request);
        for (String prefix : this.pathPrefixes) {
            if (!pathInfo.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }
}

