package com.atlassian.plugins.license.entity;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;
import java.util.StringJoiner;

public class SynchronizableVersionInfoEntity {
    public static SynchronizableVersionInfoEntity EMPTY = builder().build();

    @JsonProperty("present")
    private boolean present;

    @JsonProperty("version")
    private Long version;

    @JsonProperty("startedTime")
    private Long startedTime;

    @JsonProperty("finishedTime")
    private Long finishedTime;

    @JsonProperty("maximumNumberOfUsers")
    private Long maximumNumberOfUsers;


// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    @JsonCreator
    public SynchronizableVersionInfoEntity(@JsonProperty("present") boolean present, @JsonProperty("version") Long version,
                                              @JsonProperty("startedTime") Long startedTime, @JsonProperty("finishedTime") Long finishedTime,
                                              @JsonProperty("maximumNumberOfUsers") Long maximumNumberOfUsers) {
        this.present = present;
        this.version = version;
        this.startedTime = startedTime;
        this.finishedTime = finishedTime;
        this.maximumNumberOfUsers = maximumNumberOfUsers;
    }

    public boolean isPresent() {
        return present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getStartedTime() {
        return startedTime;
    }

    public void setStartedTime(Long startedTime) {
        this.startedTime = startedTime;
    }

    public Long getFinishedTime() {
        return finishedTime;
    }

    public void setFinishedTime(Long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public Long getMaximumNumberOfUsers() {
        return maximumNumberOfUsers;
    }

    public void setMaximumNumberOfUsers(Long maximumNumberOfUsers) {
        this.maximumNumberOfUsers = maximumNumberOfUsers;
    }

    public static SynchronizableVersionInfoEntity.Builder builder() {
        return new SynchronizableVersionInfoEntity.Builder();
    }

    public static SynchronizableVersionInfoEntity.Builder builder(SynchronizableVersionInfoEntity data) {
        return new SynchronizableVersionInfoEntity.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SynchronizableVersionInfoEntity that = (SynchronizableVersionInfoEntity) o;

        return Objects.equals(this.isPresent(), that.isPresent()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getStartedTime(), that.getStartedTime()) && Objects.equals(this.getFinishedTime(), that.getFinishedTime()) && Objects.equals(this.getMaximumNumberOfUsers(), that.getMaximumNumberOfUsers());
    }

    @Override
    public int hashCode() {
        return Objects.hash(isPresent(), getVersion(), getStartedTime(), getFinishedTime(), getMaximumNumberOfUsers());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]")
                .add("present=" + isPresent())
                .add("version=" + getVersion())
                .add("startedTime=" + getStartedTime())
                .add("finishedTime=" + getFinishedTime())
                .add("maximumNumberOfUsers=" + getMaximumNumberOfUsers())
                .toString();
    }

    public static final class Builder {

        private boolean present;
        private Long version;
        private Long startedTime;
        private Long finishedTime;
        private Long maximumNumberOfUsers;

        private Builder() {
        }

        private Builder(SynchronizableVersionInfoEntity initialData) {
            this.present = initialData.isPresent();
            this.version = initialData.getVersion();
            this.startedTime = initialData.getStartedTime();
            this.finishedTime = initialData.getFinishedTime();
            this.maximumNumberOfUsers = initialData.getMaximumNumberOfUsers();
        }

        public Builder setPresent(boolean present) {
            this.present = present;
            return this;
        }

        public Builder setVersion(Long version) {
            this.version = version;
            return this;
        }

        public Builder setStartedTime(Long startedTime) {
            this.startedTime = startedTime;
            return this;
        }

        public Builder setFinishedTime(Long finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public Builder setMaximumNumberOfUsers(Long maximumNumberOfUsers) {
            this.maximumNumberOfUsers = maximumNumberOfUsers;
            return this;
        }

        public SynchronizableVersionInfoEntity build() {
            return new SynchronizableVersionInfoEntity(present, version, startedTime, finishedTime, maximumNumberOfUsers);
        }
    }
}
