package com.atlassian.plugins.license.entity;

import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class RestPage<T> {

    @JsonProperty("start")
    private int start;
    @JsonProperty("limit")
    private int limit;
    @JsonProperty("isLastPage")
    private boolean isLastPage;
    @JsonProperty("values")
    private List<T> values;

    public static <T> RestPage<T> fromLimitPlusOne(List<T> results, int start, int limit) {
        boolean lastPage = results.size() <= limit;
        return RestPage.<T>builder()
                .setIsLastPage(lastPage)
                .setStart(start)
                .setLimit(limit)
                .setValues(lastPage ? results : results.subList(0, limit))
                .build();
    }

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    @JsonCreator
    public RestPage(@JsonProperty("start") int start, @JsonProperty("limit") int limit,
                    @JsonProperty("isLastPage") boolean isLastPage, @JsonProperty("values") List<T> values) {
        this.start = start;
        this.limit = limit;
        this.isLastPage = isLastPage;
        this.values = values != null ? new ArrayList<>(values) : null;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean getIsLastPage() {
        return isLastPage;
    }

    public void setIsLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }

    public List<T> getValues() {
        return values;
    }

    public void setValues(List<T> values) {
        this.values = values != null ? new ArrayList<>(values) : null;
    }

    public static <T> RestPage.Builder<T> builder() {
        return new RestPage.Builder<>();
    }

    public static <T> RestPage.Builder<T> builder(RestPage<T> data) {
        return new RestPage.Builder<>(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        RestPage that = (RestPage) o;

        return Objects.equals(this.getStart(), that.getStart()) && Objects.equals(this.getLimit(), that.getLimit()) && Objects.equals(this.getIsLastPage(), that.getIsLastPage()) && Objects.equals(this.getValues(), that.getValues());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getStart(), getLimit(), getIsLastPage(), getValues());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]")
                .add("start=" + getStart())
                .add("limit=" + getLimit())
                .add("isLastPage=" + getIsLastPage())
                .add("values=" + getValues())
                .toString();
    }

    public static final class Builder<T> {

        private int start;
        private int limit;
        private boolean isLastPage;
        private List<T> values = new ArrayList<>();

        private Builder() {
        }

        private Builder(RestPage<T> initialData) {
            this.start = initialData.getStart();
            this.limit = initialData.getLimit();
            this.isLastPage = initialData.getIsLastPage();
            this.values = new ArrayList<>(initialData.getValues());
        }

        public Builder<T> setStart(int start) {
            this.start = start;
            return this;
        }

        public Builder<T> setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder<T> setIsLastPage(boolean isLastPage) {
            this.isLastPage = isLastPage;
            return this;
        }

        public Builder<T> setValues(List<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> addValue(T value) {
            this.values.add(value);
            return this;
        }

        public Builder<T> addValues(Iterable<T> values) {
            for (T value : values) {
                addValue(value);
            }
            return this;
        }

        public RestPage<T> build() {
            return new RestPage<>(start, limit, isLastPage, values);
        }
    }
}
