package com.atlassian.plugins.license.entity;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;
import java.util.StringJoiner;

public class LicensedUserInfoEntity {

    @JsonProperty("username")
    private String username;

    @JsonProperty("email")
    private String email;

    @JsonProperty("displayName")
    private String displayName;

    @JsonProperty("externalId")
    private String externalId;

    @JsonProperty("crowdDirectoryId")
    private Long crowdDirectoryId;

    @JsonProperty("directoryId")
    private Long directoryId;

    @JsonProperty("remoteCrowdUser")
    private boolean remoteCrowdUser;

    @JsonProperty("lastLoginTime")
    private Long lastLoginTime;

    @JsonProperty("applicationKey")
    private String applicationKey;


// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    @JsonCreator
    public LicensedUserInfoEntity(@JsonProperty("username") String username, @JsonProperty("email") String email,
                                  @JsonProperty("displayName") String displayName, @JsonProperty("externalId") String externalId,
                                  @JsonProperty("crowdDirectoryId") Long crowdDirectoryId, @JsonProperty("directoryId") Long directoryId,
                                  @JsonProperty("remoteCrowdUser") boolean remoteCrowdUser, @JsonProperty("lastLoginTime") Long lastLoginTime,
                                  @JsonProperty("applicationKey") String applicationKey) {
        this.username = username;
        this.email = email;
        this.displayName = displayName;
        this.externalId = externalId;
        this.crowdDirectoryId = crowdDirectoryId;
        this.directoryId = directoryId;
        this.remoteCrowdUser = remoteCrowdUser;
        this.lastLoginTime = lastLoginTime;
        this.applicationKey = applicationKey;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Long getCrowdDirectoryId() {
        return crowdDirectoryId;
    }

    public void setCrowdDirectoryId(Long crowdDirectoryId) {
        this.crowdDirectoryId = crowdDirectoryId;
    }

    public Long getDirectoryId() {
        return directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public boolean isRemoteCrowdUser() {
        return remoteCrowdUser;
    }

    public void setRemoteCrowdUser(boolean remoteCrowdUser) {
        this.remoteCrowdUser = remoteCrowdUser;
    }

    public Long getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Long lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getApplicationKey() {
        return applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public static LicensedUserInfoEntity.Builder builder() {
        return new LicensedUserInfoEntity.Builder();
    }

    public static LicensedUserInfoEntity.Builder builder(LicensedUserInfoEntity data) {
        return new LicensedUserInfoEntity.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LicensedUserInfoEntity that = (LicensedUserInfoEntity) o;

        return Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getEmail(), that.getEmail()) && Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getExternalId(), that.getExternalId()) && Objects.equals(this.getCrowdDirectoryId(), that.getCrowdDirectoryId()) && Objects.equals(this.getDirectoryId(), that.getDirectoryId()) && Objects.equals(this.isRemoteCrowdUser(), that.isRemoteCrowdUser()) && Objects.equals(this.getLastLoginTime(), that.getLastLoginTime()) && Objects.equals(this.getApplicationKey(), that.getApplicationKey());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getUsername(), getEmail(), getDisplayName(), getExternalId(), getCrowdDirectoryId(), getDirectoryId(), isRemoteCrowdUser(), getLastLoginTime(), getApplicationKey());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]")
                .add("username=" + getUsername())
                .add("email=" + getEmail())
                .add("displayName=" + getDisplayName())
                .add("externalId=" + getExternalId())
                .add("crowdDirectoryId=" + getCrowdDirectoryId())
                .add("directoryId=" + getDirectoryId())
                .add("remoteCrowdUser=" + isRemoteCrowdUser())
                .add("lastLoginTime=" + getLastLoginTime())
                .add("applicationKey=" + getApplicationKey())
                .toString();
    }

    public static final class Builder {

        private String username;
        private String email;
        private String displayName;
        private String externalId;
        private Long crowdDirectoryId;
        private Long directoryId;
        private boolean remoteCrowdUser;
        private Long lastLoginTime;
        private String applicationKey;

        private Builder() {
        }

        private Builder(LicensedUserInfoEntity initialData) {
            this.username = initialData.getUsername();
            this.email = initialData.getEmail();
            this.displayName = initialData.getDisplayName();
            this.externalId = initialData.getExternalId();
            this.crowdDirectoryId = initialData.getCrowdDirectoryId();
            this.directoryId = initialData.getDirectoryId();
            this.remoteCrowdUser = initialData.isRemoteCrowdUser();
            this.lastLoginTime = initialData.getLastLoginTime();
            this.applicationKey = initialData.getApplicationKey();
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder setCrowdDirectoryId(Long crowdDirectoryId) {
            this.crowdDirectoryId = crowdDirectoryId;
            return this;
        }

        public Builder setDirectoryId(Long directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public Builder setRemoteCrowdUser(boolean remoteCrowdUser) {
            this.remoteCrowdUser = remoteCrowdUser;
            return this;
        }

        public Builder setLastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        public Builder setApplicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public LicensedUserInfoEntity build() {
            return new LicensedUserInfoEntity(username, email, displayName, externalId, crowdDirectoryId, directoryId, remoteCrowdUser, lastLoginTime, applicationKey);
        }
    }
}
