/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.domain.model.vendor;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.model.vendor.SupportOrganisation;
import com.atlassian.plugins.domain.model.vendor.VendorRelationship;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Vendor
extends AbstractDTO {
    public static final String EXPAND_PLUGIN = "plugin";
    public static final String EXPAND_PLUGINS = "plugins";
    public static final String EXPAND_SUPPORT_ORGANISATION = "supportOrganisation";
    public static final String EXPAND_SUPPORT_ORGANISATIONS = "supportOrganisations";
    public static final String EXPAND_VENDOR_RELATIONSHIP = "vendorRelationship";
    public static final String EXPAND_VENDOR_RELATIONSHIPS = "vendorRelationships";
    private String name;
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String state;
    private String postCode;
    private String country;
    private String url;
    private String email;
    private String phone;
    private String otherContactDetails;
    private String createdBy;
    @Expand(value="supportOrganisations")
    @XmlElement
    private ListWrapper<SupportOrganisation> supportOrganisations = new ListWrapper();
    @Expand(value="vendorRelationships")
    @XmlElement
    private ListWrapper<VendorRelationship> vendorRelationships = new ListWrapper();
    @Expand(value="plugins")
    @XmlElement
    private ListWrapper<Plugin> plugins = new ListWrapper();

    @Override
    public boolean beforeMarshal(Marshaller marshaller) {
        if (!this.isExpanded()) {
            this.put(EXPAND_SUPPORT_ORGANISATIONS, this.supportOrganisations);
            this.put(EXPAND_VENDOR_RELATIONSHIPS, this.vendorRelationships);
            this.put(EXPAND_PLUGINS, this.plugins);
            this.supportOrganisations = null;
            this.vendorRelationships = null;
            this.plugins = null;
        }
        return true;
    }

    @Override
    public void afterMarshal(Marshaller marshaller) {
        if (!this.isExpanded()) {
            this.supportOrganisations = (ListWrapper)this.get(EXPAND_SUPPORT_ORGANISATIONS);
            this.vendorRelationships = (ListWrapper)this.get(EXPAND_VENDOR_RELATIONSHIPS);
            this.plugins = (ListWrapper)this.get(EXPAND_PLUGINS);
        }
    }

    public boolean hasUsername(String username) {
        if (username == null || this.vendorRelationships == null) {
            return false;
        }
        for (VendorRelationship vendorRelationship : this.vendorRelationships) {
            if (vendorRelationship == null || vendorRelationship.getUser() == null || vendorRelationship.getUser().getUsername() == null || !vendorRelationship.getUser().getUsername().equals(username)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOtherContactDetails() {
        return this.otherContactDetails;
    }

    public void setOtherContactDetails(String otherContactDetails) {
        this.otherContactDetails = otherContactDetails;
    }

    public ListWrapper<SupportOrganisation> getSupportOrganisations() {
        return this.supportOrganisations;
    }

    public void setSupportOrganisations(ListWrapper<SupportOrganisation> supportOrganisations) {
        this.supportOrganisations = supportOrganisations;
    }

    public ListWrapper<VendorRelationship> getVendorRelationships() {
        return this.vendorRelationships;
    }

    public void setVendorRelationships(ListWrapper<VendorRelationship> vendorRelationships) {
        this.vendorRelationships = vendorRelationships;
    }

    public ListWrapper<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(ListWrapper<Plugin> plugins) {
        this.plugins = plugins;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}

