package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicApi;
import com.atlassian.sal.api.user.UserKey;

import java.net.URI;

/**
 * Check if outgoing access to a given uri is allowed or not.
 * @since 1.0
 */
@PublicApi
public interface OutboundWhitelist extends Whitelist
{
    /**
     * Checks if requests to the provided URI are allowed according to the
     * current whitelist configuration, including rules that inspect auth
     * status.
     * @param uri     the uri to which an http request is made
     * @param userKey the userKey of the user to check for auth-required rules.
     * @return        true if requests are allowed, false otherwise
     */
    boolean isAllowed(URI uri, UserKey userKey);
}
