package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.WebResourceSet;

import javax.annotation.Nonnull;

class DefaultAssembledResources implements AssembledResources {
    private final DefaultWebResourceSetBuilder builder;

    DefaultAssembledResources(@Nonnull final RequestState requestState) {
        builder = new DefaultWebResourceSetBuilder(requestState);
    }

    @Nonnull
    @Override
    public WebResourceSet drainIncludedResources() {
        return builder.enableDrainBigPipe()
                       .disableBlockOnBigPipe()
                       .enableCleanUpAfterInclude()
                       .enableAdditionOfWebResourceJavascriptApiDependencies()
                       .enableSuperbatch()
                       .build();
    }

    @Override
    public WebResourceSet drainIncludedSyncResources() {
        return builder.enableDrainBigPipe()
                       .disableBlockOnBigPipe()
                       .enableCleanUpAfterInclude()
                       .disableAdditionOfWebResourceJavascriptApiDependencies()
                       .disableSuperbatch()
                       .build();
    }

    @Nonnull
    @Override
    public WebResourceSet pollIncludedResources() {
        return builder.enableDrainBigPipe()
                       .enableBlockOnBigPipe()
                       .enableCleanUpAfterInclude()
                       .disableAdditionOfWebResourceJavascriptApiDependencies()
                       .enableSuperbatch()
                       .build();
    }

    @Nonnull
    @Override
    public WebResourceSet peek() {
        return builder.disableDrainBigPipe()
                       .disableBlockOnBigPipe()
                       .disableCleanUpAfterInclude()
                       .disableAdditionOfWebResourceJavascriptApiDependencies()
                       .enableSuperbatch()
                       .build();
    }
}
