package com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.stream;

import com.atlassian.plugin.servlet.ServletContextFactory;

import java.io.InputStream;

public class TomcatStreamStrategy implements StreamStrategy {
    private final ServletContextFactory servletContextFactory;

    TomcatStreamStrategy(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public InputStream getInputStream(String path) {
        String pathWithSlash = path.startsWith("/") ? path : "/" + path;
        return servletContextFactory.getServletContext().getResourceAsStream(pathWithSlash);
    }
}
