/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformer;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.transformer.ContentTransformerFactory;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.StaticTransformersSupplier;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.url.UrlBuilder;

public class DefaultStaticTransformers
implements StaticTransformers {
    private final StaticTransformersSupplier staticTransformersSupplier;

    public DefaultStaticTransformers(StaticTransformersSupplier staticTransformersSupplier) {
        this.staticTransformersSupplier = staticTransformersSupplier;
    }

    @Override
    public void addToUrl(String locationType, TransformerParameters transformerParameters, UrlBuilder urlBuilder, UrlBuildingStrategy urlBuildingStrategy) {
        for (ContentTransformerFactory transformerFactory : this.transformersForType(locationType)) {
            urlBuildingStrategy.addToUrl(transformerFactory.makeUrlBuilder(transformerParameters), urlBuilder);
        }
    }

    @Override
    public Content transform(CdnResourceUrlTransformer cdnResourceUrlTransformer, Content content, TransformerParameters transformerParameters, ResourceLocation resourceLocation, QueryParams queryParams, String sourceUrl) {
        for (ContentTransformerFactory transformerFactory : this.transformersForLocation(resourceLocation)) {
            content = transformerFactory.makeResourceTransformer(transformerParameters).transform(cdnResourceUrlTransformer, content, resourceLocation, queryParams, sourceUrl);
        }
        return content;
    }

    private Iterable<ContentTransformerFactory> transformersForType(String locationType) {
        return this.staticTransformersSupplier.get(locationType);
    }

    private Iterable<ContentTransformerFactory> transformersForLocation(ResourceLocation location) {
        return this.staticTransformersSupplier.get(location);
    }
}

