/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.support;

import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.helpers.UrlGenerationHelpers;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public interface UrlCache {
    public UrlGenerationHelpers.CalculatedBatches getBatches(IncludedExcludedConditionsAndBatchingOptions var1, BatchesProvider var2);

    public LinkedHashSet<String> getResolvedExcluded(IncludedExcludedConditionsAndBatchingOptions var1, ResolvedExcludedProvider var2);

    public void clear();

    public static class PassThrough
    implements UrlCache {
        @Override
        public UrlGenerationHelpers.CalculatedBatches getBatches(IncludedExcludedConditionsAndBatchingOptions key, BatchesProvider provider) {
            return provider.get(key);
        }

        @Override
        public LinkedHashSet<String> getResolvedExcluded(IncludedExcludedConditionsAndBatchingOptions key, ResolvedExcludedProvider provider) {
            return provider.get(key);
        }

        @Override
        public void clear() {
        }
    }

    public static class Impl
    implements UrlCache {
        private Cache<IncludedAndExcluded, List<CachedCondition>> cachedConditions;
        private Cache<IncludedExcludedConditionsAndBatchingOptions, UrlGenerationHelpers.CalculatedBatches> cachedBatches;
        private Cache<IncludedExcludedConditionsAndBatchingOptions, LinkedHashSet<String>> cachedResolvedExcluded;

        public Impl(int size) {
            this.cachedConditions = CacheBuilder.newBuilder().maximumSize((long)size).build();
            this.cachedBatches = CacheBuilder.newBuilder().maximumSize((long)size).build();
            this.cachedResolvedExcluded = CacheBuilder.newBuilder().maximumSize((long)size).build();
        }

        @Override
        public UrlGenerationHelpers.CalculatedBatches getBatches(final IncludedExcludedConditionsAndBatchingOptions key, final BatchesProvider provider) {
            try {
                return (UrlGenerationHelpers.CalculatedBatches)this.cachedBatches.get((Object)key, (Callable)new Callable<UrlGenerationHelpers.CalculatedBatches>(){

                    @Override
                    public UrlGenerationHelpers.CalculatedBatches call() throws Exception {
                        return provider.get(key);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public LinkedHashSet<String> getResolvedExcluded(final IncludedExcludedConditionsAndBatchingOptions key, final ResolvedExcludedProvider provider) {
            try {
                return (LinkedHashSet)this.cachedResolvedExcluded.get((Object)key, (Callable)new Callable<LinkedHashSet<String>>(){

                    @Override
                    public LinkedHashSet<String> call() throws Exception {
                        return provider.get(key);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void clear() {
            this.cachedConditions.invalidateAll();
            this.cachedBatches.invalidateAll();
            this.cachedResolvedExcluded.invalidateAll();
        }
    }

    public static interface ResolvedExcludedProvider {
        public LinkedHashSet<String> get(IncludedExcludedConditionsAndBatchingOptions var1);
    }

    public static interface BatchesProvider {
        public UrlGenerationHelpers.CalculatedBatches get(IncludedExcludedConditionsAndBatchingOptions var1);
    }

    public static class IncludedExcludedConditionsAndBatchingOptions {
        private final IncludedAndExcluded inludedAndExcluded;
        private final Set<EvaluatedCondition> evaluatedConditions;
        private final boolean resplitMergedContextBatchesForThisRequest;

        public IncludedExcludedConditionsAndBatchingOptions(IncludedAndExcluded includedAndExcluded, Set<EvaluatedCondition> evaluatedConditions, boolean resplitMergedContextBatchesForThisRequest) {
            this.inludedAndExcluded = (IncludedAndExcluded)Preconditions.checkNotNull((Object)includedAndExcluded);
            this.evaluatedConditions = (Set)Preconditions.checkNotNull(evaluatedConditions);
            this.resplitMergedContextBatchesForThisRequest = resplitMergedContextBatchesForThisRequest;
        }

        public LinkedHashSet<String> getIncluded() {
            return this.inludedAndExcluded.getIncluded();
        }

        public LinkedHashSet<String> getExcluded() {
            return this.inludedAndExcluded.getExcluded();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IncludedExcludedConditionsAndBatchingOptions)) {
                return false;
            }
            IncludedExcludedConditionsAndBatchingOptions that = (IncludedExcludedConditionsAndBatchingOptions)o;
            if (this.resplitMergedContextBatchesForThisRequest != that.resplitMergedContextBatchesForThisRequest) {
                return false;
            }
            if (!this.evaluatedConditions.equals(that.evaluatedConditions)) {
                return false;
            }
            return this.inludedAndExcluded.equals(that.inludedAndExcluded);
        }

        public int hashCode() {
            int result = this.inludedAndExcluded.hashCode();
            result = 31 * result + this.evaluatedConditions.hashCode();
            result = 31 * result + (this.resplitMergedContextBatchesForThisRequest ? 1 : 0);
            return result;
        }
    }

    public static class EvaluatedCondition
    extends Tuple<CachedCondition, Boolean> {
        public EvaluatedCondition(CachedCondition cachedCondition, Boolean evaluationResult) {
            super(cachedCondition, evaluationResult);
        }
    }

    public static class IncludedAndExcluded
    extends Tuple<LinkedHashSet<String>, LinkedHashSet<String>> {
        public IncludedAndExcluded(LinkedHashSet<String> included, LinkedHashSet<String> excluded) {
            super(included, excluded);
        }

        public LinkedHashSet<String> getIncluded() {
            return (LinkedHashSet)this.getFirst();
        }

        public LinkedHashSet<String> getExcluded() {
            return (LinkedHashSet)this.getLast();
        }
    }
}

