/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.helpers;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.ContextSubBatchResourceUrl;
import com.atlassian.plugin.webresource.ResourceUrl;
import com.atlassian.plugin.webresource.ResourceUrlImpl;
import com.atlassian.plugin.webresource.WebResourceSubBatchUrl;
import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.BaseHelpers;
import com.atlassian.plugin.webresource.impl.helpers.StateEncodedUrlResult;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.plugin.webresource.impl.support.UrlCache;
import com.atlassian.plugin.webresource.impl.support.http.BaseRouter;
import com.atlassian.plugin.webresource.legacy.LegacyUrlGenerationHelpers;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UrlGenerationHelpers
extends BaseHelpers {
    private static final HashSet<String> PARAMS_SORT_ORDER_SET = new HashSet<String>(Config.PARAMS_SORT_ORDER);

    public static Resolved resolve(final RequestState requestState) {
        if (requestState.getIncluded().isEmpty()) {
            return new Resolved(new LinkedHashMap<String, Jsonable>(), new ArrayList<ResourceUrl>(), requestState.getExcluded());
        }
        UrlCache.IncludedExcludedConditionsAndBatchingOptions cacheKey = UrlGenerationHelpers.buildIncludedExcludedConditionsAndBatchingOptions(requestState.getCache(), requestState.getUrlStrategy(), requestState.getIncluded(), requestState.getExcluded());
        CalculatedBatches calculatedBatches = requestState.getGlobals().getUrlCache().getBatches(cacheKey, new UrlCache.BatchesProvider(){

            @Override
            public CalculatedBatches get(UrlCache.IncludedExcludedConditionsAndBatchingOptions key) {
                return UrlGenerationHelpers.calculateBatches(requestState.getCache(), requestState.getUrlStrategy(), key.getIncluded(), key.getExcluded());
            }
        });
        List<String> dataResources = requestState.getSnapshot().find().included(requestState.getIncluded()).excluded(requestState.getExcluded()).deepFilter(UrlGenerationHelpers.isConditionsSatisfied(requestState.getCache(), requestState.getUrlStrategy())).end();
        LinkedHashMap<String, Jsonable> dataJsonResources = UrlGenerationHelpers.buildDataResources(requestState, dataResources);
        List<ResourceUrl> resourceUrls = UrlGenerationHelpers.collectUrlStateAndBuildResourceUrls(requestState, requestState.getUrlStrategy(), calculatedBatches.contextBatches, calculatedBatches.webResourceBatches);
        return new Resolved(dataJsonResources, resourceUrls, calculatedBatches.excludedResolved);
    }

    protected static UrlCache.IncludedExcludedConditionsAndBatchingOptions buildIncludedExcludedConditionsAndBatchingOptions(RequestCache requestCache, UrlBuildingStrategy urlBuilderStrategy, LinkedHashSet<String> included, LinkedHashSet<String> excluded) {
        UrlCache.IncludedAndExcluded includedAndExcluded = new UrlCache.IncludedAndExcluded(new LinkedHashSet<String>(included), new LinkedHashSet<String>(excluded));
        Set<CachedCondition> conditions = UrlGenerationHelpers.getConditions(requestCache, includedAndExcluded, urlBuilderStrategy);
        HashSet<UrlCache.EvaluatedCondition> evaluatedConditions = new HashSet<UrlCache.EvaluatedCondition>();
        for (CachedCondition condition : conditions) {
            evaluatedConditions.add(new UrlCache.EvaluatedCondition(condition, condition.evaluateSafely(requestCache, urlBuilderStrategy)));
        }
        return new UrlCache.IncludedExcludedConditionsAndBatchingOptions(includedAndExcluded, evaluatedConditions, requestCache.getGlobals().getConfig().resplitMergedContextBatchesForThisRequest());
    }

    protected static Set<CachedCondition> getConditions(RequestCache requestCache, UrlCache.IncludedAndExcluded includedAndExcluded, UrlBuildingStrategy urlBuilderStrategy) {
        HashSet<CachedCondition> conditions = new HashSet<CachedCondition>();
        requestCache.getSnapshot().find().included(includedAndExcluded.getIncluded()).excluded(includedAndExcluded.getExcluded()).deepFilter((Predicate<Bundle>)((Predicate)bundle -> {
            CachedCondition condition = bundle.getCondition();
            if (condition != null) {
                conditions.add(condition);
                if (condition.isLegacy()) {
                    return true;
                }
                return condition.evaluateSafely(requestCache, urlBuilderStrategy);
            }
            return true;
        })).end();
        return conditions;
    }

    public static LinkedHashSet<String> resolveExcluded(final RequestCache requestCache, final UrlBuildingStrategy urlBuilderStrategy, List<String> allIncluded, LinkedHashSet<String> allExcluded) {
        UrlCache.IncludedExcludedConditionsAndBatchingOptions cacheKey = UrlGenerationHelpers.buildIncludedExcludedConditionsAndBatchingOptions(requestCache, urlBuilderStrategy, new LinkedHashSet<String>(allIncluded), allExcluded);
        return requestCache.getGlobals().getUrlCache().getResolvedExcluded(cacheKey, new UrlCache.ResolvedExcludedProvider(){

            @Override
            public LinkedHashSet<String> get(UrlCache.IncludedExcludedConditionsAndBatchingOptions key) {
                return LegacyUrlGenerationHelpers.calculateBatches((RequestCache)requestCache, (UrlBuildingStrategy)urlBuilderStrategy, key.getIncluded(), key.getExcluded(), (boolean)false).excludedResolved;
            }
        });
    }

    protected static CalculatedBatches calculateBatches(RequestCache requestCache, UrlBuildingStrategy urlBuilderStrategy, LinkedHashSet<String> included, LinkedHashSet<String> excluded) {
        LegacyUrlGenerationHelpers.Resolved resolved = LegacyUrlGenerationHelpers.calculateBatches(requestCache, urlBuilderStrategy, included, excluded, false);
        Tuple<List<ContextBatch>, List<WebResourceBatch>> subBatches = UrlGenerationHelpers.splitIntoSubBatches(requestCache, urlBuilderStrategy, resolved.contextBatchKeys, resolved.webResourceBatchKeys);
        List<ContextBatch> contextBatches = subBatches.getFirst();
        List<WebResourceBatch> webResourceBatches = subBatches.getLast();
        return new CalculatedBatches(contextBatches, webResourceBatches, resolved.excludedResolved);
    }

    protected static LinkedHashMap<String, Jsonable> buildDataResources(RequestState requestState, List<String> webResourceKeys) {
        LinkedHashMap<String, Jsonable> dataResources = new LinkedHashMap<String, Jsonable>();
        for (Bundle bundle : requestState.getSnapshot().toBundles(webResourceKeys)) {
            for (Map.Entry<String, Jsonable> entry : bundle.getData().entrySet()) {
                dataResources.put(bundle.getKey() + "." + entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : requestState.getIncludedData().entrySet()) {
            if (requestState.getExcludedData().contains(entry.getKey())) continue;
            dataResources.put((String)entry.getKey(), (Jsonable)entry.getValue());
        }
        return dataResources;
    }

    protected static List<ResourceUrl> collectUrlStateAndBuildResourceUrls(RequestState requestState, UrlBuildingStrategy urlBuilderStrategy, List<ContextBatch> contextBatches, List<WebResourceBatch> webResourceBatches) {
        RequestCache requestCache = requestState.getCache();
        Globals globals = requestCache.getGlobals();
        ArrayList<ResourceUrl> resourceUrls = new ArrayList<ResourceUrl>();
        for (String type : Config.BATCH_TYPES) {
            DefaultUrlBuilder urlBuilder;
            StateEncodedUrlResult taintAndUrlBuilder;
            for (ContextBatch contextBatch : contextBatches) {
                Object paramsComparator;
                ArrayList contextBatchResourceUrls = new ArrayList();
                for (SubBatch subBatch : contextBatch.subBatches) {
                    if (subBatch.getResourcesOfType(requestCache, type).isEmpty()) continue;
                    taintAndUrlBuilder = UrlGenerationHelpers.encodeStateInUrlIfSupported(requestCache, urlBuilderStrategy, type, subBatch.resourcesParams, subBatch.bundles, requestCache.getSnapshot().toBundles(contextBatch.skippedWebResourcesWithUrlReadingConditions));
                    boolean taint = taintAndUrlBuilder.isTaint();
                    urlBuilder = taintAndUrlBuilder.getUrlBuilder();
                    contextBatchResourceUrls.add(new ContextSubBatchResourceUrl(requestCache.getGlobals(), contextBatch, subBatch, type, urlBuilder.buildParams(), urlBuilder.buildHash(), taint, urlBuilder.getPrebakeErrors()));
                }
                if (contextBatch.isAdditionalSortingRequired) {
                    paramsComparator = new ParamsComparator();
                    Collections.sort(contextBatchResourceUrls, new Comparator<ResourceUrl>((ParamsComparator)paramsComparator){
                        final /* synthetic */ ParamsComparator val$paramsComparator;
                        {
                            this.val$paramsComparator = paramsComparator;
                        }

                        @Override
                        public int compare(ResourceUrl a, ResourceUrl b) {
                            int result = this.val$paramsComparator.compare(a.getParams(), b.getParams());
                            String aUrl = BaseRouter.buildUrl("", a.getParams());
                            String bUrl = BaseRouter.buildUrl("", b.getParams());
                            return result == 0 ? aUrl.compareTo(bUrl) : result;
                        }
                    });
                }
                if (globals.getConfig().isContextBatchingEnabled()) {
                    resourceUrls.addAll(contextBatchResourceUrls);
                } else {
                    paramsComparator = contextBatchResourceUrls.iterator();
                    while (paramsComparator.hasNext()) {
                        ContextSubBatchResourceUrl contextSubBatchResourceUrl = (ContextSubBatchResourceUrl)paramsComparator.next();
                        Map<String, String> contextBatchResourceParams = contextSubBatchResourceUrl.getSubBatch().resourcesParams;
                        SubBatch subBatch = contextSubBatchResourceUrl.getSubBatch();
                        List<Resource> contextBatchResources = subBatch.getResourcesOfType(requestCache, type);
                        LinkedHashMap<Bundle, ArrayList<Resource>> bundles = new LinkedHashMap<Bundle, ArrayList<Resource>>();
                        for (Resource resource : contextBatchResources) {
                            ArrayList<Resource> bundleResources = (ArrayList<Resource>)bundles.get(resource.getParent());
                            if (bundleResources == null) {
                                bundleResources = new ArrayList<Resource>();
                                bundles.put(resource.getParent(), bundleResources);
                            }
                            bundleResources.add(resource);
                        }
                        for (Map.Entry entry : bundles.entrySet()) {
                            Bundle bundle = (Bundle)entry.getKey();
                            List resources = (List)entry.getValue();
                            StateEncodedUrlResult taintAndUrlBuilder2 = UrlGenerationHelpers.encodeStateInUrlIfSupported(requestCache, urlBuilderStrategy, type, contextBatchResourceParams, bundle, new ArrayList<Bundle>());
                            boolean taint = taintAndUrlBuilder2.isTaint();
                            DefaultUrlBuilder urlBuilder2 = taintAndUrlBuilder2.getUrlBuilder();
                            String webResourceBatchHash = urlBuilder2.buildHash();
                            Map<String, String> webResourceBatchHttpParams = urlBuilder2.buildParams();
                            if (globals.getConfig().isWebResourceBatchingEnabled()) {
                                SubBatch webResourceSubBatch = new SubBatch(webResourceBatchHttpParams, bundle, (List<Resource>)resources);
                                resourceUrls.add(new WebResourceSubBatchUrl(requestCache.getGlobals(), bundle.getKey(), webResourceSubBatch, type, webResourceBatchHttpParams, webResourceBatchHash, taint, urlBuilder2.getPrebakeErrors()));
                                continue;
                            }
                            for (Resource resource : resources) {
                                resourceUrls.add(new ResourceUrlImpl(globals, resource, webResourceBatchHttpParams, webResourceBatchHash, taint, urlBuilder2.getPrebakeErrors()));
                            }
                        }
                    }
                }
                resourceUrls.addAll(UrlGenerationHelpers.createResourceUrlsForRedirectResources(requestCache, urlBuilderStrategy, contextBatch.getStandaloneResourcesOfType(requestCache, type)));
            }
            for (WebResourceBatch webResourceBatch : webResourceBatches) {
                for (SubBatch subBatch : webResourceBatch.subBatches) {
                    List<Resource> resources = subBatch.getResourcesOfType(requestCache, type);
                    if (resources.size() <= 0) continue;
                    taintAndUrlBuilder = UrlGenerationHelpers.encodeStateInUrlIfSupported(requestCache, urlBuilderStrategy, type, subBatch.resourcesParams, subBatch.bundles, new ArrayList<Bundle>());
                    boolean taint = taintAndUrlBuilder.isTaint();
                    urlBuilder = taintAndUrlBuilder.getUrlBuilder();
                    if (globals.getConfig().isWebResourceBatchingEnabled()) {
                        resourceUrls.add(new WebResourceSubBatchUrl(requestCache.getGlobals(), webResourceBatch.key, subBatch, type, urlBuilder.buildParams(), urlBuilder.buildHash(), taint, urlBuilder.getPrebakeErrors()));
                        continue;
                    }
                    for (Resource resource : resources) {
                        resourceUrls.add(new ResourceUrlImpl(globals, resource, urlBuilder.buildParams(), urlBuilder.buildHash(), taint, urlBuilder.getPrebakeErrors()));
                    }
                }
                resourceUrls.addAll(UrlGenerationHelpers.createResourceUrlsForRedirectResources(requestCache, urlBuilderStrategy, webResourceBatch.getStandaloneResourcesOfType(requestCache, type)));
            }
            if (!globals.getConfig().amdEnabled() || webResourceBatches.isEmpty()) continue;
            for (String key : requestState.getIncluded()) {
                Bundle bundle;
                if (!Config.isContextKey(key) || requestState.getExcluded().contains(key) || (bundle = requestCache.getSnapshot().get(key)) == null) continue;
                for (Resource resource : bundle.getResources(requestCache).values()) {
                    if (!type.equals(resource.getContentType())) continue;
                    resourceUrls.add(new ResourceUrlImpl(globals, resource, new HashMap<String, String>(), "", false, new ArrayList<PrebakeError>()));
                }
            }
        }
        return resourceUrls;
    }

    protected static Tuple<List<ContextBatch>, List<WebResourceBatch>> splitIntoSubBatches(RequestCache requestCache, UrlBuildingStrategy urlBuilderStrategy, List<ContextBatchKey> contextBatchKeys, List<String> webResourceBatchKeys) {
        SplitSubBatches result;
        ArrayList<ContextBatch> contextBatches = new ArrayList<ContextBatch>();
        for (ContextBatchKey key : contextBatchKeys) {
            BaseHelpers.Found found = requestCache.getSnapshot().find().included(key.included).excluded(key.excluded).deepFilter(UrlGenerationHelpers.isConditionsSatisfied(requestCache, urlBuilderStrategy)).deepFilter((Predicate<Bundle>)Predicates.not(UrlGenerationHelpers.hasLegacyCondition())).endAndGetResult();
            ArrayList<String> skippedWebResourcesWithUrlReadingConditions = new ArrayList<String>();
            for (Bundle bundle : requestCache.getSnapshot().toBundles(found.skipped)) {
                if (bundle.getCondition() == null || bundle.getCondition().isLegacy()) continue;
                skippedWebResourcesWithUrlReadingConditions.add(bundle.getKey());
            }
            result = UrlGenerationHelpers.splitBatchIntoSubBatches(requestCache, found.found, true);
            contextBatches.add(new ContextBatch(key.included, key.excluded, skippedWebResourcesWithUrlReadingConditions, result.contextSubBatches, result.contextStandaloneResources, result.isAdditionalSortingRequired));
        }
        ArrayList<WebResourceBatch> webResourceBatches = new ArrayList<WebResourceBatch>();
        for (String key : webResourceBatchKeys) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(key);
            result = UrlGenerationHelpers.splitBatchIntoSubBatches(requestCache, keys, false);
            if (result.contextSubBatches.size() > 0 && result.legacyWebResources.size() == 0) {
                webResourceBatches.add(new WebResourceBatch(key, result.contextSubBatches, result.contextStandaloneResources));
                continue;
            }
            if (result.contextSubBatches.size() == 0 && result.legacyWebResources.size() > 0) {
                if (result.contextStandaloneResources.size() > 0) {
                    throw new RuntimeException("single web resource cannot have context standalone resources!");
                }
                if (result.legacyWebResources.size() > 1) {
                    throw new RuntimeException("single web resource cannot split into multiple web resources!");
                }
                webResourceBatches.add(result.legacyWebResources.get(0));
                continue;
            }
            if (contextBatchKeys.size() <= 0 || result.legacyWebResources.size() <= 0) continue;
            throw new RuntimeException("single web resource batch could be either legacy or not, but not both at the same time!");
        }
        return new Tuple<List<ContextBatch>, List<WebResourceBatch>>(contextBatches, webResourceBatches);
    }

    protected static SplitSubBatches splitBatchIntoSubBatches(RequestCache requestCache, Iterable<String> completeKeys, boolean doSorting) {
        String IS_STANDALONE = "_isStandalone";
        List<Bundle> bundles = requestCache.getSnapshot().toBundles(completeKeys);
        final HashMap<Resource, Integer> allResourcesOrdered = new HashMap<Resource, Integer>();
        int i = 0;
        Comparator<Resource> RESOURCE_COMPARATOR = new Comparator<Resource>(){

            @Override
            public int compare(Resource a, Resource b) {
                return (Integer)allResourcesOrdered.get(a) - (Integer)allResourcesOrdered.get(b);
            }
        };
        LinkedHashMap<Map<String, String>, ArrayList<Resource>> uniqueParams = new LinkedHashMap<Map<String, String>, ArrayList<Resource>>();
        LinkedHashMap legacyUniqueParams = new LinkedHashMap();
        for (Bundle bundle : bundles) {
            for (Resource resource : bundle.getResources(requestCache).values()) {
                ArrayList<Resource> resources;
                allResourcesOrdered.put(resource, i);
                ++i;
                Map<String, String> params = resource.getUrlParams();
                if (!resource.isBatchable()) {
                    params.put("_isStandalone", "true");
                }
                if (!resource.getParent().hasLegacyConditions()) {
                    ArrayList<Resource> resources2 = (ArrayList<Resource>)uniqueParams.get(params);
                    if (resources2 == null) {
                        resources2 = new ArrayList<Resource>();
                        uniqueParams.put(params, resources2);
                    }
                    resources2.add(resource);
                    continue;
                }
                LinkedHashMap<Map<String, String>, ArrayList<Resource>> webResourceUniqueParams = (LinkedHashMap<Map<String, String>, ArrayList<Resource>>)legacyUniqueParams.get(resource.getParent());
                if (webResourceUniqueParams == null) {
                    webResourceUniqueParams = new LinkedHashMap<Map<String, String>, ArrayList<Resource>>();
                    legacyUniqueParams.put(resource.getParent(), webResourceUniqueParams);
                }
                if ((resources = (ArrayList<Resource>)webResourceUniqueParams.get(params)) == null) {
                    resources = new ArrayList<Resource>();
                    webResourceUniqueParams.put(params, resources);
                }
                resources.add(resource);
            }
        }
        SplitSubBatches result = new SplitSubBatches();
        ArrayList uniqueParamsSorted = new ArrayList(uniqueParams.keySet());
        ParamsComparator paramsComparator = new ParamsComparator();
        if (doSorting) {
            Collections.sort(uniqueParamsSorted, paramsComparator);
        }
        result.isAdditionalSortingRequired = paramsComparator.isAdditionalSortingRequired();
        LinkedHashMap legacyUniqueParamsSorted = new LinkedHashMap();
        for (Map.Entry entry : legacyUniqueParams.entrySet()) {
            ArrayList webResourceUniqueParamsSorted = new ArrayList(((Map)entry.getValue()).keySet());
            legacyUniqueParamsSorted.put(entry.getKey(), webResourceUniqueParamsSorted);
        }
        result.contextSubBatches = new ArrayList<SubBatch>();
        result.contextStandaloneResources = new ArrayList<Resource>();
        for (Map params : uniqueParamsSorted) {
            if (params.containsKey("_isStandalone")) {
                result.contextStandaloneResources.addAll((Collection)uniqueParams.get(params));
                continue;
            }
            result.contextSubBatches.add(new SubBatch((Map<String, String>)params, bundles, (List<Resource>)((List)uniqueParams.get(params))));
        }
        Collections.sort(result.contextStandaloneResources, RESOURCE_COMPARATOR);
        result.legacyWebResources = new ArrayList<WebResourceBatch>();
        for (Map.Entry entry : legacyUniqueParams.entrySet()) {
            ArrayList<Resource> webResourceStandaloneResources = new ArrayList<Resource>();
            ArrayList<SubBatch> webResourceSubBatches = new ArrayList<SubBatch>();
            for (Map params : (List)legacyUniqueParamsSorted.get(entry.getKey())) {
                if (params.containsKey("_isStandalone")) {
                    webResourceStandaloneResources.addAll((Collection)uniqueParams.get(params));
                    continue;
                }
                List resources = (List)((Map)legacyUniqueParams.get(entry.getKey())).get(params);
                webResourceSubBatches.add(new SubBatch((Map<String, String>)params, (Bundle)entry.getKey(), (List<Resource>)resources));
            }
            Collections.sort(webResourceStandaloneResources, RESOURCE_COMPARATOR);
            result.legacyWebResources.add(new WebResourceBatch(((Bundle)entry.getKey()).getKey(), webResourceSubBatches, webResourceStandaloneResources));
        }
        return result;
    }

    protected static List<Resource> resourcesOfType(Collection<Resource> resources, String type) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (!type.equals(resource.getNameOrLocationType())) continue;
            result.add(resource);
        }
        return result;
    }

    protected static StateEncodedUrlResult encodeStateInUrlIfSupported(RequestCache requestCache, UrlBuildingStrategy urlBuilderStrategy, String type, Map<String, String> params, Bundle bundle, List<Bundle> skipped) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        bundles.add(bundle);
        return UrlGenerationHelpers.encodeStateInUrlIfSupported(requestCache, urlBuilderStrategy, type, params, bundles, skipped);
    }

    protected static StateEncodedUrlResult encodeStateInUrlIfSupported(RequestCache requestCache, UrlBuildingStrategy urlBuilderStrategy, String type, Map<String, String> params, List<Bundle> bundles, List<Bundle> skipped) {
        DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            urlBuilder.addToQueryString(entry.getKey(), entry.getValue());
        }
        ArrayList<Bundle> allBundles = new ArrayList<Bundle>();
        allBundles.addAll(bundles);
        allBundles.addAll(skipped);
        boolean taint = false;
        for (Bundle bundle : allBundles) {
            CachedTransformers transformers;
            CachedCondition condition = bundle.getCondition();
            if (condition != null) {
                condition.addToUrlSafely(requestCache, urlBuilder, urlBuilderStrategy);
                taint |= condition.isLegacy();
            }
            if ((transformers = bundle.getTransformers()) != null) {
                for (String locationType : bundle.getLocationResourceTypesFor(type)) {
                    taint |= transformers.addToUrlSafely(urlBuilder, urlBuilderStrategy, locationType, requestCache.getGlobals().getConfig().getTransformerCache(), bundle.getTransformerParameters(), bundle.getKey());
                }
            }
            for (String locationType : bundle.getLocationResourceTypesFor(type)) {
                requestCache.getGlobals().getConfig().getStaticTransformers().addToUrl(locationType, bundle.getTransformerParameters(), urlBuilder, urlBuilderStrategy);
            }
        }
        return new StateEncodedUrlResult(taint, urlBuilder);
    }

    protected static List<ResourceUrl> createResourceUrlsForRedirectResources(RequestCache requestCache, UrlBuildingStrategy urlBuilderStrategy, List<Resource> resources) {
        ArrayList<ResourceUrl> resourceUrls = new ArrayList<ResourceUrl>();
        for (Resource resource : resources) {
            CachedTransformers transformers;
            DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
            for (Map.Entry<String, String> entry : resource.getParams().entrySet()) {
                urlBuilder.addToQueryString(entry.getKey(), entry.getValue());
            }
            boolean taint = false;
            Bundle webResource = resource.getParent();
            CachedCondition condition = webResource.getCondition();
            if (condition != null) {
                condition.addToUrlSafely(requestCache, urlBuilder, urlBuilderStrategy);
                taint |= condition.isLegacy();
            }
            if ((transformers = webResource.getTransformers()) != null) {
                taint |= transformers.addToUrlSafely(urlBuilder, urlBuilderStrategy, resource.getLocationType(), requestCache.getGlobals().getConfig().getTransformerCache(), webResource.getTransformerParameters(), webResource.getKey());
            }
            requestCache.getGlobals().getConfig().getStaticTransformers().addToUrl(resource.getLocationType(), webResource.getTransformerParameters(), urlBuilder, urlBuilderStrategy);
            resourceUrls.add(new ResourceUrlImpl(requestCache.getGlobals(), resource, urlBuilder.buildParams(), urlBuilder.buildHash(), taint, urlBuilder.getPrebakeErrors()));
        }
        return resourceUrls;
    }

    public static final class ParamsComparator
    implements Comparator<Map<String, String>> {
        private boolean isAdditionalSortingRequired = false;

        @Override
        public int compare(Map<String, String> a, Map<String, String> b) {
            Sets.SetView aKeys = Sets.intersection(a.keySet(), (Set)PARAMS_SORT_ORDER_SET);
            Sets.SetView bKeys = Sets.intersection(b.keySet(), (Set)PARAMS_SORT_ORDER_SET);
            if (aKeys.size() == 1 && bKeys.size() == 1) {
                int bIndex;
                String aKey = (String)Iterables.getOnlyElement((Iterable)aKeys);
                String bKey = (String)Iterables.getOnlyElement((Iterable)bKeys);
                int aIndex = Config.PARAMS_SORT_ORDER.indexOf(aKey);
                if (aIndex != (bIndex = Config.PARAMS_SORT_ORDER.indexOf(bKey))) {
                    return aIndex - bIndex;
                }
            }
            if (aKeys.size() == bKeys.size()) {
                this.isAdditionalSortingRequired |= true;
                return 0;
            }
            return aKeys.size() - bKeys.size();
        }

        public boolean isAdditionalSortingRequired() {
            return this.isAdditionalSortingRequired;
        }
    }

    protected static class SplitSubBatches {
        List<SubBatch> contextSubBatches;
        List<Resource> contextStandaloneResources;
        List<WebResourceBatch> legacyWebResources;
        boolean isAdditionalSortingRequired;

        protected SplitSubBatches() {
        }
    }

    public static class CalculatedBatches {
        public final List<ContextBatch> contextBatches;
        public final List<WebResourceBatch> webResourceBatches;
        public final LinkedHashSet<String> excludedResolved;

        public CalculatedBatches(List<ContextBatch> contextBatches, List<WebResourceBatch> webResourceBatches, LinkedHashSet<String> excludedResolved) {
            this.contextBatches = contextBatches;
            this.webResourceBatches = webResourceBatches;
            this.excludedResolved = excludedResolved;
        }
    }

    public static class Resolved {
        public final LinkedHashMap<String, Jsonable> data;
        public final List<ResourceUrl> urls;
        public final LinkedHashSet<String> excludedResolved;

        Resolved(LinkedHashMap<String, Jsonable> data, List<ResourceUrl> urls, LinkedHashSet<String> excludedResolved) {
            this.data = data;
            this.urls = urls;
            this.excludedResolved = excludedResolved;
        }
    }

    public static class SubBatch {
        public final Map<String, String> resourcesParams;
        public final List<Bundle> bundles;
        private final Map<String, RequestCache.ResourceKeysSupplier> resourceKeysByType = new HashMap<String, RequestCache.ResourceKeysSupplier>();

        public SubBatch(Map<String, String> resourcesParams, Bundle bundle, List<Resource> resources) {
            this(resourcesParams, Lists.newArrayList((Object[])new Bundle[]{bundle}), resources);
        }

        public SubBatch(Map<String, String> resourcesParams, List<Bundle> bundles, List<Resource> resources) {
            this.resourcesParams = resourcesParams;
            this.bundles = bundles;
            for (String type : Config.BATCH_TYPES) {
                RequestCache.ResourceKeysSupplier resourceKeysSupplier = new RequestCache.ResourceKeysSupplier(RequestCache.toResourceKeys(UrlGenerationHelpers.resourcesOfType(resources, type)));
                this.resourceKeysByType.put(type, resourceKeysSupplier);
            }
        }

        public List<Resource> getResourcesOfType(RequestCache requestCache, String type) {
            return requestCache.getCachedResources(this.resourceKeysByType.get(type));
        }
    }

    public static class ContextBatch {
        public final List<String> included;
        public final LinkedHashSet<String> excluded;
        public final List<String> skippedWebResourcesWithUrlReadingConditions;
        public final List<SubBatch> subBatches;
        protected final Map<String, RequestCache.ResourceKeysSupplier> standaloneResourceKeysByType = new HashMap<String, RequestCache.ResourceKeysSupplier>();
        public final boolean isAdditionalSortingRequired;

        public ContextBatch(List<String> included, LinkedHashSet<String> excluded, List<String> skippedWebResourcesWithUrlReadingConditions, List<SubBatch> subBatches, List<Resource> standaloneResources, boolean isAdditionalSortingRequired) {
            this.included = included;
            this.excluded = excluded;
            this.skippedWebResourcesWithUrlReadingConditions = skippedWebResourcesWithUrlReadingConditions;
            this.subBatches = subBatches;
            for (String type : Config.BATCH_TYPES) {
                RequestCache.ResourceKeysSupplier resourceKeysSupplier = new RequestCache.ResourceKeysSupplier(RequestCache.toResourceKeys(UrlGenerationHelpers.resourcesOfType(standaloneResources, type)));
                this.standaloneResourceKeysByType.put(type, resourceKeysSupplier);
            }
            this.isAdditionalSortingRequired = isAdditionalSortingRequired;
        }

        public List<Resource> getStandaloneResourcesOfType(RequestCache requestCache, String type) {
            return requestCache.getCachedResources(this.standaloneResourceKeysByType.get(type));
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(StringUtils.join(this.included, (String)", "));
            if (this.excluded.size() > 0) {
                buff.append("-");
                buff.append(StringUtils.join(this.excluded, (String)", "));
            }
            return buff.toString();
        }
    }

    public static class WebResourceBatch {
        public final String key;
        public final List<SubBatch> subBatches;
        protected final Map<String, RequestCache.ResourceKeysSupplier> standaloneResourceKeysByType = new HashMap<String, RequestCache.ResourceKeysSupplier>();

        public WebResourceBatch(String key, List<SubBatch> subBatches, List<Resource> standaloneResources) {
            this.key = key;
            this.subBatches = subBatches;
            for (String type : Config.BATCH_TYPES) {
                RequestCache.ResourceKeysSupplier resourceKeysSupplier = new RequestCache.ResourceKeysSupplier(RequestCache.toResourceKeys(UrlGenerationHelpers.resourcesOfType(standaloneResources, type)));
                this.standaloneResourceKeysByType.put(type, resourceKeysSupplier);
            }
        }

        public List<Resource> getStandaloneResourcesOfType(RequestCache requestCache, String type) {
            return requestCache.getCachedResources(this.standaloneResourceKeysByType.get(type));
        }
    }

    public static class ContextBatchKey {
        public final List<String> included;
        public LinkedHashSet<String> excluded;

        public ContextBatchKey(List<String> included, LinkedHashSet<String> excluded) {
            this.included = included;
            this.excluded = excluded;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("[").append(StringUtils.join(this.included, (String)", "));
            if (this.excluded.size() > 0) {
                buff.append("-");
                buff.append(StringUtils.join(this.excluded, (String)", "));
            }
            return buff.append("]").toString();
        }
    }
}

