/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.annotators;

import com.atlassian.plugin.webresource.impl.annotators.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.ContextResource;
import com.atlassian.plugin.webresource.impl.snapshot.ModuleResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;

public class LocationContentAnnotator
extends ResourceContentAnnotator {
    @Override
    public int beforeResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream out) throws IOException {
        if (!(resource instanceof ModuleResource)) {
            if (resource instanceof ContextResource) {
                out.write(("/* loading modules for context \"" + Config.virtualContextKeyToWebResourceKey(resource.getParent().getKey()) + "\" */\n").getBytes());
            } else {
                out.write(String.format("/* module-key = '%s', location = '%s' */\n", resource.getKey(), resource.getLocation()).getBytes());
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

