/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class JavascriptWebResource
extends AbstractWebResourceFormatter {
    public static final WebResourceFormatter FORMATTER = new JavascriptWebResource();
    private static final String JAVA_SCRIPT_EXTENSION = ".js";
    private static final String CONDITION_PARAM = "conditionalComment";
    private static final List<String> HANDLED_PARAMETERS = Arrays.asList("charset");

    @Override
    public boolean matches(String name) {
        return name != null && name.endsWith(JAVA_SCRIPT_EXTENSION);
    }

    @Override
    public String formatResource(String url, Map<String, String> attributes) {
        return this.formatResource(url, attributes, false);
    }

    public String formatResource(String url, Map<String, String> attributes, boolean enableDeferJsAttribute) {
        StringBuffer buffer = new StringBuffer("<script type=\"text/javascript\" ");
        buffer.append("src=\"").append(StringEscapeUtils.escapeHtml((String)url)).append("\" ");
        if (enableDeferJsAttribute) {
            buffer.append("defer ");
        }
        buffer.append(StringUtils.join(this.getParametersAsAttributes(attributes).iterator(), (String)" "));
        buffer.append("></script>\n");
        if (attributes.containsKey(CONDITION_PARAM)) {
            String condition = attributes.get(CONDITION_PARAM);
            buffer.insert(0, "<!--[if " + condition + "]>\n");
            buffer.append("<![endif]-->\n");
        } else if (BooleanUtils.toBoolean((String)attributes.get("ieonly"))) {
            buffer.insert(0, "<!--[if IE]>\n");
            buffer.append("<![endif]-->\n");
        }
        return buffer.toString();
    }

    @Override
    protected List<String> getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

