package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.webresource.impl.RequestCache;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * Context.
 *
 * @since v3.4.4
 */
public class Context extends Bundle
{
    private final List<String> moduleDependencies;

    public Context(Snapshot snapshot, String key, List<String> dependencies, List<String> moduleDependencies,
        Date updatedAt, String version, boolean isTransformable)
    {
        super(snapshot, key, dependencies, updatedAt, version, isTransformable);
        this.moduleDependencies = moduleDependencies;
    }

    @Override
    public LinkedHashMap<String, Resource> getResources(RequestCache cache)
    {
        LinkedHashMap<String, Resource> resources = new LinkedHashMap<>();
        if (!moduleDependencies.isEmpty())
        {
            Resource resource = new ContextResource(this, moduleDependencies);
            resources.put(resource.getName(), resource);
        }
        return resources;
    }
}
