package com.atlassian.plugin.webresource.impl.annotators;

import com.atlassian.plugin.webresource.impl.snapshot.ModuleResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * Wraps AMD module inside of `WRM.atlassianModule`, needed by AMD loader to resolve dependencies.
 *
 * @since v6.3
 */
public class ModuleAnnotator extends ResourceContentAnnotator
{
    @Override
    public int beforeResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException
    {
        return before(requiredResources, resource, stream);
    }

    @Override
    public int beforeResource(LinkedHashSet<String> requiredResources, String url, Resource resource, OutputStream stream) throws IOException
    {
        return before(requiredResources, resource, stream);
    }

    @Override
    public void afterResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException
    {
        after(requiredResources, resource, stream);
    }

    @Override
    public void afterResource(LinkedHashSet<String> requiredResources, String url, Resource resource, OutputStream stream) throws IOException
    {
        after(requiredResources, resource, stream);
    }

    protected int before(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException
    {
        if (!(resource instanceof ModuleResource))
        {
            return 0;
        }
        ModuleResource moduleResource = (ModuleResource) resource;
        stream.write(("\nWRM.atlassianModule(\"" + moduleResource.getParent().getKey() + "\"").getBytes());
        stream.write(", {".getBytes());
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : moduleResource.getUnresolvedDependencies().entrySet())
        {
            // Skipping if dependency is the same as resolved dependency to minimize the size of batch.
            if (isFirst)
            {
                isFirst = false;
            }
            else
            {
                stream.write(", ".getBytes());
            }
            stream.write("\"".getBytes());
            stream.write(entry.getKey().getBytes());
            stream.write("\": \"".getBytes());
            stream.write(entry.getValue().getBytes());
            stream.write("\"".getBytes());
        }
        stream.write(("}, function(define) {\n").getBytes());
        return 1;
    }

    protected void after(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException
    {
        if (resource instanceof ModuleResource)
        {
            stream.write("\n});\n".getBytes());
            // Resolving immediately if it's explicitly required.
            if (requiredResources.contains(resource.getParent().getKey()))
            {
                stream.write(("require([\"" + resource.getParent().getKey() + "\"]);\n").getBytes());
            }
        }
    }

    @Override
    public int hashCode()
    {
        return getClass().getName().hashCode();
    }
}