/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.support.http;

import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.http.Request;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class Response {
    private final Request request;
    private final HttpServletResponse originalResponse;

    public Response(Globals globals, Request request, HttpServletResponse response) {
        this.request = request;
        this.originalResponse = response;
    }

    public void sendRedirect(Resource resource) {
        this.sendRedirect(resource.getLocation(), resource.getContentType());
    }

    public void sendRedirect(String location, String contentType) {
        this.setContentTypeIfNotBlank(contentType);
        try {
            this.request.getOriginalRequest().getRequestDispatcher(location).forward((ServletRequest)this.request.getOriginalRequest(), (ServletResponse)this.originalResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ServletException e2) {
            throw new RuntimeException(e2);
        }
    }

    public HttpServletResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public void sendError(int code) {
        try {
            this.originalResponse.sendError(code);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContentType(String contentType) {
        this.originalResponse.setContentType(contentType);
    }

    public OutputStream getOutputStream() {
        try {
            return this.originalResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContentTypeIfNotBlank(String contentType) {
        if (StringUtils.isNotBlank((String)contentType)) {
            this.setContentType(contentType);
        }
    }

    public void setStatus(int status) {
        this.originalResponse.setStatus(status);
    }
}

