/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ResourceUrl;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.helpers.UrlGenerationHelpers;
import com.atlassian.plugin.webresource.impl.http.Router;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ContextSubBatchResourceUrl
extends ResourceUrl {
    private final String key;
    private final Globals globals;
    private final String type;
    private final UrlGenerationHelpers.ContextBatch contextBatch;
    private final UrlGenerationHelpers.SubBatch subBatch;
    private final String hash;
    private final Map<String, String> params;
    private final boolean hasLegacyTransformers;

    public ContextSubBatchResourceUrl(Globals globals, UrlGenerationHelpers.ContextBatch contextBatch, UrlGenerationHelpers.SubBatch subBatch, String type, Map<String, String> params, String hash, boolean hasLegacyTransformers, List<PrebakeError> prebakeErrors) {
        super(prebakeErrors);
        this.globals = globals;
        this.contextBatch = contextBatch;
        this.subBatch = subBatch;
        this.hash = hash;
        this.params = params;
        this.key = Router.encodeContexts(contextBatch.included, contextBatch.excluded);
        this.type = type;
        this.hasLegacyTransformers = hasLegacyTransformers;
    }

    public UrlGenerationHelpers.SubBatch getSubBatch() {
        return this.subBatch;
    }

    public List<Bundle> getBatchedBundles() {
        return this.subBatch.bundles;
    }

    public List<String> getIncludedContexts() {
        return this.contextBatch.included;
    }

    public LinkedHashSet<String> getExcludedContexts() {
        return this.contextBatch.excluded;
    }

    @Override
    public String getName() {
        return this.getKey() + "." + this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getUrl(boolean isAbsolute) {
        boolean isCacheable = Resource.isCacheableStatic(this.subBatch.resourcesParams);
        boolean hasLegacyConditions = false;
        for (Bundle bundle : this.subBatch.bundles) {
            if (!bundle.hasLegacyConditions()) continue;
            hasLegacyConditions = true;
            break;
        }
        boolean isCdnSupported = !hasLegacyConditions && !this.hasLegacyTransformers;
        return this.globals.getRouter().cloneWithNewUrlMode(isAbsolute).contextBatchUrl(this.getKey(), this.getType(), this.getParams(), isCacheable, isCdnSupported, this.hash, this.calculateHash());
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    private String calculateHash() {
        HashBuilder versionHashBuilder = new HashBuilder();
        for (Bundle bundle : this.subBatch.bundles) {
            versionHashBuilder.add(bundle.getKey());
            versionHashBuilder.add(bundle.getVersion());
        }
        return versionHashBuilder.build();
    }

    @Override
    public PluginUrlResource.BatchType getBatchType() {
        return PluginUrlResource.BatchType.CONTEXT;
    }
}

