/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.fugue.Option;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.Config;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.ContentImpl;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.Helpers;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.atlassian.plugin.webresource.data.DefaultPluginDataResource;
import com.atlassian.plugin.webresource.http.Controller;
import com.atlassian.plugin.webresource.http.Router;
import com.atlassian.plugin.webresource.support.http.Request;
import com.atlassian.plugin.webresource.support.http.Response;
import com.atlassian.plugin.webresource.transformer.DefaultStaticTransformers;
import com.atlassian.plugin.webresource.transformer.DefaultStaticTransformersSupplier;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilderMap;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourceLocatorImpl
implements PluginResourceLocator {
    private static final Logger log = LoggerFactory.getLogger(PluginResourceLocatorImpl.class);
    private final PluginAccessor pluginAccessor;
    private final TransformerCache transformerCache;
    private final StaticTransformers staticTransformers;
    private final ResourceBatchingConfiguration batchingConfiguration;
    static final String RESOURCE_SOURCE_PARAM = "source";
    private final Globals globals;

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, PluginEventManager pluginEventManager) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceBatchingConfiguration(), pluginEventManager);
    }

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, PluginEventManager pluginEventManager) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration), batchingConfiguration, pluginEventManager, new DefaultStaticTransformers(new DefaultStaticTransformersSupplier(webResourceIntegration, webResourceUrlProvider)));
    }

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, PluginEventManager pluginEventManager, StaticTransformers staticTransformers) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration), batchingConfiguration, pluginEventManager, staticTransformers);
    }

    private PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceDependencyResolver dependencyResolver, ResourceBatchingConfiguration batchingConfiguration, PluginEventManager pluginEventManager, StaticTransformers staticTransformers) {
        this.pluginAccessor = webResourceIntegration.getPluginAccessor();
        this.staticTransformers = staticTransformers;
        this.batchingConfiguration = batchingConfiguration;
        this.transformerCache = new TransformerCache(pluginEventManager, this.pluginAccessor);
        Config config = new Config(batchingConfiguration, webResourceIntegration, webResourceUrlProvider, servletContextFactory, staticTransformers, this.transformerCache);
        this.globals = new Globals(config);
        this.globals.buildAndSetCache();
        this.globals.setRouter(new Router(this.globals));
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.globals.triggerStateChange();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.globals.triggerStateChange();
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof WebResourceModuleDescriptor) {
            this.globals.triggerStateChange();
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof WebResourceModuleDescriptor) {
            this.globals.triggerStateChange();
        }
    }

    @Override
    public boolean matches(String url) {
        return this.globals.getRouter().canDispatch(url);
    }

    @Override
    public DownloadableResource getDownloadableResource(String url, Map<String, String> queryParams) {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        final DownloadableResource[] downloadableResource = new DownloadableResource[]{null};
        Router router = new Router(this.globals){

            @Override
            protected Controller createController(Globals globals, Request request, Response response) {
                return new Controller(globals, request, response){

                    @Override
                    protected void sendCached(String cacheKey, Content content, boolean isCacheEnabled) {
                        final Controller.CachedContent cachedContent = this.buildCachedContent(cacheKey, content, isCacheEnabled);
                        downloadableResource[0] = Helpers.asDownloadableResource(new ContentImpl(content.getContentType(), content.isTransformed()){

                            @Override
                            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                                cachedContent.writeTo(out, null, null, false, null);
                                return null;
                            }
                        });
                    }

                    @Override
                    protected boolean checkIfCachedAndNotModified(Date updatedAt) {
                        return false;
                    }
                };
            }
        };
        router.dispatch(new Request(this.globals, url, queryParams), null);
        return downloadableResource[0];
    }

    @Override
    public Iterable<PluginDataResource> getPluginDataResources(String moduleCompleteKey, ConditionsCache conditionsCache) {
        Option<WebResourceModuleDescriptor> option = this.getDescriptor(moduleCompleteKey);
        if (option.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getPluginDataResources((WebResourceModuleDescriptor)((Object)option.get()), conditionsCache);
    }

    @Override
    public Iterable<PluginDataResource> getPluginDataResources(final WebResourceModuleDescriptor moduleDescriptor, ConditionsCache conditionsCache) {
        if (moduleDescriptor.getDataProviders().isEmpty() || moduleDescriptor.canEncodeStateIntoUrl() && !moduleDescriptor.shouldDisplayImmediate(conditionsCache)) {
            return new ArrayList<PluginDataResource>();
        }
        return Iterables.transform(moduleDescriptor.getDataProviders().entrySet(), (Function)new Function<Map.Entry<String, WebResourceDataProvider>, PluginDataResource>(){

            public PluginDataResource apply(Map.Entry<String, WebResourceDataProvider> input) {
                return new DefaultPluginDataResource(moduleDescriptor.getCompleteKey() + "." + input.getKey(), (Jsonable)input.getValue().get());
            }
        });
    }

    @Override
    public List<PluginResource> getPluginResources(String moduleCompleteKey, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        Option<WebResourceModuleDescriptor> option = this.getDescriptor(moduleCompleteKey);
        if (option.isEmpty()) {
            return Collections.emptyList();
        }
        WebResourceModuleDescriptor wrmd = (WebResourceModuleDescriptor)((Object)option.get());
        return this.getPluginResources(wrmd, conditionsRun, conditionsCache);
    }

    @Override
    public List<PluginResource> getPluginResources(WebResourceModuleDescriptor wrmd, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        boolean singleMode = !this.batchingConfiguration.isPluginWebResourceBatchingEnabled();
        LinkedHashSet<AbstractPluginResource> resources = new LinkedHashSet<AbstractPluginResource>();
        DefaultUrlBuilderMap urlBuilderMap = new DefaultUrlBuilderMap(wrmd, this.transformerCache, this.staticTransformers);
        HashSet<String> urlParametersContributedForDestinationTypes = new HashSet<String>();
        for (ResourceDescriptor resourceDescriptor : wrmd.getResourceDescriptors()) {
            String sourceType = ResourceUtils.getType(resourceDescriptor.getLocation());
            String destinationType = ResourceUtils.getType(resourceDescriptor.getName());
            UrlParameters urlParams = urlBuilderMap.getOrCreateForType(sourceType, conditionsRun, conditionsCache, this.globals);
            urlParametersContributedForDestinationTypes.add(destinationType);
            if (singleMode || this.skipBatch(resourceDescriptor)) {
                boolean cache = !"false".equalsIgnoreCase(resourceDescriptor.getParameter("cache"));
                resources.add(new SinglePluginResource(this.globals, resourceDescriptor.getName(), wrmd.getCompleteKey(), cache, urlParams, resourceDescriptor.getParameters()));
                continue;
            }
            BatchPluginResource batchResource = this.createBatchResource(wrmd.getCompleteKey(), resourceDescriptor.getParameters(), destinationType, urlParams, new BatchedWebResourceDescriptor(wrmd.getPlugin().getPluginInformation().getVersion(), wrmd.getCompleteKey()));
            resources.add(batchResource);
        }
        if (wrmd.getCondition() != null && wrmd.getDependencies().size() > 0) {
            for (String destionationType : Arrays.asList("css", "js")) {
                if (urlParametersContributedForDestinationTypes.contains(destionationType) || !this.hasResourcesOfTypeInHerselfOrInDependencies(wrmd.getCompleteKey(), destionationType, new HashSet<String>())) continue;
                UrlParameters urlParams = urlBuilderMap.getOrCreateForType(destionationType, conditionsRun, conditionsCache, this.globals);
                if (singleMode) continue;
                resources.add(this.createBatchResource(wrmd.getCompleteKey(), new HashMap<String, String>(), destionationType, urlParams, new BatchedWebResourceDescriptor(wrmd.getPlugin().getPluginInformation().getVersion(), wrmd.getCompleteKey())));
            }
        }
        return ImmutableList.copyOf(resources);
    }

    private boolean hasResourcesOfTypeInHerselfOrInDependencies(String key, String type, Set<String> visited) {
        if (visited.contains(key)) {
            return false;
        }
        visited.add(key);
        WebResourceModuleDescriptor descriptor = this.getWebResourceModuleDescriptor(key);
        if (descriptor == null) {
            return false;
        }
        for (ResourceDescriptor resourceDescriptor : descriptor.getResourceDescriptors()) {
            if (!type.equals(ResourceUtils.getType(resourceDescriptor.getName()))) continue;
            return true;
        }
        for (String dependencyKey : descriptor.getDependencies()) {
            if (!this.hasResourcesOfTypeInHerselfOrInDependencies(dependencyKey, type, visited)) continue;
            return true;
        }
        return false;
    }

    private WebResourceModuleDescriptor getWebResourceModuleDescriptor(String key) {
        ModuleDescriptor moduleDescriptor;
        try {
            moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(key);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            return null;
        }
        return (WebResourceModuleDescriptor)moduleDescriptor;
    }

    @Override
    public Option<WebResourceModuleDescriptor> getDescriptor(String moduleCompleteKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null || !(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            log.error("Error loading resource \"{}\". Resource is not a Web Resource Module", (Object)moduleCompleteKey);
            return Option.none();
        }
        return Option.some((Object)((Object)((WebResourceModuleDescriptor)moduleDescriptor)));
    }

    private BatchPluginResource createBatchResource(String completeKey, Map<String, String> resourceParameters, String type, UrlParameters urlParams, BatchedWebResourceDescriptor batchedWebResourceDescriptor) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String param : BATCH_PARAMS) {
            String value = resourceParameters.get(param);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            params.put(param, value);
        }
        return new BatchPluginResource(this.globals, completeKey, type, urlParams, params, batchedWebResourceDescriptor);
    }

    @Override
    public TransformerCache getTransformerCache() {
        return this.transformerCache;
    }

    @Override
    public Globals temporaryWayToGetGlobalsDoNotUseIt() {
        return this.globals;
    }

    private boolean skipBatch(ResourceDescriptor resourceDescriptor) {
        boolean doNotBatch = "false".equalsIgnoreCase(resourceDescriptor.getParameter("batch"));
        return doNotBatch || "webContext".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_SOURCE_PARAM));
    }
}

