/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.assembler.WebResourceSetCache;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.google.common.annotations.VisibleForTesting;

public class DefaultWebResourceAssemblerFactory
implements WebResourceAssemblerFactory {
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final WebResourceIntegration webResourceIntegration;
    private final PluginResourceLocator pluginResourceLocator;
    private final StaticTransformers staticTransformers;
    private final WebResourceSetCache webResourceSetCache;

    public DefaultWebResourceAssemblerFactory(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, PluginResourceLocator pluginResourceLocator, StaticTransformers staticTransformers) {
        this.batchingConfiguration = batchingConfiguration;
        this.webResourceIntegration = webResourceIntegration;
        this.pluginResourceLocator = pluginResourceLocator;
        this.staticTransformers = staticTransformers;
        this.webResourceSetCache = new WebResourceSetCache(webResourceIntegration.getCacheFactory(), staticTransformers);
        webResourceIntegration.getPluginEventManager().register((Object)this);
    }

    public WebResourceAssemblerBuilder create() {
        return new DefaultWebResourceAssemblerBuilder(this.batchingConfiguration, this.webResourceIntegration, this.pluginResourceLocator, this.staticTransformers, this.webResourceSetCache);
    }

    @VisibleForTesting
    WebResourceSetCache getWebResourceSetCache() {
        return this.webResourceSetCache;
    }

    public void clearCache() {
        this.webResourceSetCache.clear();
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.webResourceSetCache.clear();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.webResourceSetCache.clear();
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof WebResourceModuleDescriptor) {
            this.webResourceSetCache.clear();
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof WebResourceModuleDescriptor) {
            this.webResourceSetCache.clear();
        }
    }
}

