/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPluginResource
implements PluginResource {
    protected final UrlParameters urlParams;
    protected final Map<String, String> params;
    protected final Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors;
    protected final Globals globals;

    protected AbstractPluginResource(Globals globals, UrlParameters urlParams, Map<String, String> params, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors) {
        this.globals = globals;
        this.urlParams = urlParams;
        this.params = ImmutableMap.copyOf(params);
        this.batchedWebResourceDescriptors = batchedWebResourceDescriptors;
    }

    @Override
    public UrlParameters getUrlParameters() {
        return this.urlParams;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return this.batchedWebResourceDescriptors;
    }

    @Override
    public String getUrl() {
        return this.getUrl(false);
    }

    @Override
    public String getHash() {
        return HashBuilder.buildHash(this.urlParams.allHashes());
    }

    @Override
    public boolean isCdnSupported() {
        return this.getUrlParameters().isCdnSupported();
    }
}

