package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.google.common.base.Predicate;

/**
 * {@link com.atlassian.plugin.webresource.transformer.StaticTransformers} implementation.
 *
 * @since v3.1.0
 */
public class DefaultStaticTransformers implements StaticTransformers
{
    private final StaticTransformersSupplier staticTransformersSupplier;

    public DefaultStaticTransformers(StaticTransformersSupplier staticTransformersSupplier)
    {
        this.staticTransformersSupplier = staticTransformersSupplier;
    }

    @Override
    public void addToUrl(String type, TransformerParameters transformerParameters, UrlBuilder urlBuilder)
    {
        for (WebResourceTransformerFactory transformerFactory : transformersForType(type))
        {
            transformerFactory.makeUrlBuilder(transformerParameters).addToUrl(urlBuilder);
        }
    }

    @Override
    public DownloadableResource transform(TransformerParameters transformerParameters,
            TransformableResource resource, QueryParams queryParams)
    {
        TransformableResource lastResource = resource;
        for (WebResourceTransformerFactory transformerFactory : transformersForLocation(resource.location()))
        {
            DownloadableResource currentResource = transformerFactory.makeResourceTransformer(transformerParameters).transform(lastResource, queryParams);
            lastResource = new TransformableResource(lastResource.location(), lastResource.filePath(), currentResource);
        }
        return lastResource.nextResource();
    }

    private Iterable<WebResourceTransformerFactory> transformersForType(final String type)
    {
        return staticTransformersSupplier.get(type);
    }

    private Iterable<WebResourceTransformerFactory> transformersForLocation(final ResourceLocation location)
    {
        return staticTransformersSupplier.get(location);
    }
}
