package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;

/**
 * Default implementation of WebResourceAssemblerFactory
 * @since v3.0
 */
public class DefaultWebResourceAssemblerFactory implements WebResourceAssemblerFactory
{
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final WebResourceIntegration webResourceIntegration;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final PluginResourceLocator pluginResourceLocator;
    private final StaticTransformers staticTransformers;

    public DefaultWebResourceAssemblerFactory(ResourceBatchingConfiguration batchingConfiguration,
            WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider,
            PluginResourceLocator pluginResourceLocator, StaticTransformers staticTransformers)
    {
        this.batchingConfiguration = batchingConfiguration;
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pluginResourceLocator = pluginResourceLocator;
        this.staticTransformers = staticTransformers;
    }

    @Override
    public WebResourceAssemblerBuilder create()
    {
        return new DefaultWebResourceAssemblerBuilder(batchingConfiguration, webResourceIntegration, pluginResourceLocator,
                webResourceUrlProvider, staticTransformers);
    }
}
