package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResourceParams;

/**
 * Implementation of PluginUrlResource
 * @since 3.0
 */
abstract class DefaultPluginUrlResource<T extends PluginUrlResourceParams> implements PluginUrlResource<T>
{
    protected final WebResourceIntegration webResourceIntegration;
    protected final WebResourceUrlProvider webResourceUrlProvider;
    protected final PluginResource pluginResource;

    public DefaultPluginUrlResource(WebResourceIntegration webResourceIntegration,
            WebResourceUrlProvider webResourceUrlProvider, PluginResource pluginResource)
    {
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pluginResource = pluginResource;
    }

    @Override
    public String getStaticUrl(UrlMode urlMode)
    {
        return pluginResource.getStaticUrl(webResourceIntegration, webResourceUrlProvider, UrlModeUtils.convert(urlMode));
    }

    @Override
    public String toString()
    {
        return pluginResource.getModuleCompleteKey() + ":" + pluginResource.getResourceName();
    }
}
